/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.element;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public abstract class AbstractElementCondition<R>
implements ExpectedCondition<R> {
    private WebElement element;
    protected static final Logger LOGGER = Logger.getLogger(AbstractElementCondition.class.getName());

    public AbstractElementCondition(WebElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element can't be null.");
        }
        this.element = element;
    }

    public R apply(WebDriver driver) {
        try {
            return this.check(driver);
        }
        catch (StaleElementReferenceException ignored) {
            LOGGER.log(Level.FINE, "The element is stale.", ignored);
            return null;
        }
    }

    protected WebElement getElement() {
        return this.element;
    }

    protected abstract R check(WebDriver var1);
}

