/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.jacoco.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacocoConfiguration {
    private static final String INCLUDES_PROPERTY = "includes";
    public static final String INCLUDES_DEFAULT_VALUE = null;
    private static final String EXCLUDES_PROPERTY = "excludes";
    public static final String EXCLUDES_DEFAULT_VALUE = null;
    private static final String SEPARATOR = "\\s*;\\s*";
    private List<String> includes;
    private List<String> excludes;
    private Filter<ArchivePath> composedFilter;

    public static JacocoConfiguration fromMap(Map<String, String> map) {
        JacocoConfiguration ret = new JacocoConfiguration();
        ConfigMap c = new ConfigMap(map);
        String incls = c.get(INCLUDES_PROPERTY, INCLUDES_DEFAULT_VALUE);
        ret.includes = incls == null ? Collections.emptyList() : Arrays.asList(incls.split(SEPARATOR));
        String excls = c.get(EXCLUDES_PROPERTY, EXCLUDES_DEFAULT_VALUE);
        ret.excludes = excls == null ? Collections.emptyList() : Arrays.asList(excls.split(SEPARATOR));
        ret.composedFilter = ret.composeFilter();
        return ret;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public Filter<ArchivePath> getClassFilter() {
        return this.composedFilter;
    }

    private Filter<ArchivePath> composeFilter() {
        ArrayList filters = new ArrayList();
        filters.add(Filters.include((String)".*\\.class"));
        for (String include : this.getIncludeRegexps()) {
            filters.add(Filters.include((String)include));
        }
        for (String exclude : this.getExcludeRegexps()) {
            filters.add(Filters.exclude((String)exclude));
        }
        return new AndFilter<ArchivePath>(filters);
    }

    private List<String> getIncludeRegexps() {
        return this.convertToRegexps(this.getIncludes());
    }

    private List<String> getExcludeRegexps() {
        return this.convertToRegexps(this.getExcludes());
    }

    private List<String> convertToRegexps(List<String> patterns) {
        if (patterns.isEmpty()) {
            return patterns;
        }
        ArrayList<String> ret = new ArrayList<String>(patterns.size());
        for (String regexp : patterns) {
            regexp = regexp.replace(".", "\\/").replace("*", ".*").replace('?', '.');
            ret.add(".*" + regexp + "\\.class");
        }
        return ret;
    }

    public static boolean isJacocoAgentActive() {
        try {
            UUID.class.getDeclaredField("$jacocoAccess");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndFilter<T>
    implements Filter<T> {
        private Collection<Filter<T>> filters;

        AndFilter(Collection<Filter<T>> filters) {
            this.filters = filters;
        }

        public boolean include(T object) {
            for (Filter<T> f : this.filters) {
                if (f.include(object)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigMap {
        Map<String, String> map;

        ConfigMap(Map<String, String> map) {
            this.map = map;
        }

        String get(String key, String defaultValue) {
            String ret = this.map.get(key);
            return ret == null ? defaultValue : ret;
        }
    }
}

