/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.impl.extension.ConfigurationSysPropResolver;
import org.jboss.arquillian.config.impl.extension.FileUtils;
import org.jboss.arquillian.config.impl.extension.PropertiesParser;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationRegistrar {
    public static final String ARQUILLIAN_XML_PROPERTY = "arquillian.xml";
    public static final String ARQUILLIAN_XML_DEFAULT = "arquillian.xml";
    public static final String ARQUILLIAN_PROP_PROPERTY = "arquillian.properties";
    public static final String ARQUILLIAN_PROP_DEFAULT = "arquillian.properties";
    private Map<String, String> systemEnvironmentVars = System.getenv();
    @Inject
    @ApplicationScoped
    private InstanceProducer<ArquillianDescriptor> descriptorInst;

    public void loadConfiguration(@Observes ManagerStarted event) {
        InputStream input = FileUtils.loadArquillianXml("arquillian.xml", "arquillian.xml");
        ArquillianDescriptor descriptor = this.resolveDescriptor(input);
        PropertiesParser propertiesParser = new PropertiesParser();
        propertiesParser.addProperties(descriptor, FileUtils.loadArquillianProperties("arquillian.properties", "arquillian.properties"));
        Properties envProperties = new Properties();
        envProperties.putAll(this.systemEnvironmentVars);
        propertiesParser.addProperties(descriptor, envProperties);
        ArquillianDescriptor resolvedDesc = ConfigurationSysPropResolver.resolveSystemProperties(descriptor);
        this.descriptorInst.set((Object)resolvedDesc);
    }

    private ArquillianDescriptor resolveDescriptor(InputStream input) {
        ArquillianDescriptor descriptor = input != null ? (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).fromStream(input) : (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
        return descriptor;
    }

    void setEnvironmentVariables(Map<String, String> variables) {
        this.systemEnvironmentVars = variables;
    }
}

