/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.javers.repository.sql.session.Parameter;
import org.javers.repository.sql.session.QueryBuilder;
import org.javers.repository.sql.session.Session;

public class InsertBuilder
extends QueryBuilder<InsertBuilder> {
    private Session session;
    private String tableName;
    private String primaryKeyFieldName;
    private String sequenceName;

    InsertBuilder(Session session, String queryName) {
        this.session = session;
        this.queryName("INSERT " + queryName);
    }

    public InsertBuilder into(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public InsertBuilder value(String name, String value) {
        this.parameters.add(new Parameter.StringParameter(name, value));
        return this;
    }

    public InsertBuilder value(String name, Integer value) {
        this.parameters.add(new Parameter.IntParameter(name, value));
        return this;
    }

    public InsertBuilder value(String name, LocalDateTime value) {
        this.parameters.add(new Parameter.LocalDateTimeParameter(name, value));
        return this;
    }

    public InsertBuilder value(String name, BigDecimal value) {
        this.parameters.add(new Parameter.BigDecimalParameter(name, value));
        return this;
    }

    public InsertBuilder value(String name, Long value) {
        this.parameters.add(new Parameter.LongParameter(name, value));
        return this;
    }

    public InsertBuilder sequence(String primaryKeyFieldName, String sequenceName) {
        this.primaryKeyFieldName = primaryKeyFieldName;
        this.sequenceName = sequenceName;
        return this;
    }

    public long executeAndGetSequence() {
        return this.session.executeInsertAndGetSequence(this.getQueryName(), this.getParameters(), this.tableName, this.primaryKeyFieldName, this.sequenceName);
    }

    public void execute() {
        this.session.executeInsert(this.getQueryName(), this.getParameters(), this.tableName, this.primaryKeyFieldName, this.sequenceName);
    }
}

