/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.ExecFileLoader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.maven.BundleCreator;
import org.jacoco.maven.FileFilter;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportMojo
extends AbstractMavenReport {
    private File outputDirectory;
    private String outputEncoding;
    private String sourceEncoding;
    private File dataFile;
    private List<String> includes;
    private List<String> excludes;
    private boolean skip;
    private MavenProject project;
    private Renderer siteRenderer;
    private SessionInfoStore sessionInfoStore;
    private ExecutionDataStore executionDataStore;

    public String getOutputName() {
        return "jacoco/index";
    }

    public String getName(Locale locale) {
        return "JaCoCo";
    }

    public String getDescription(Locale locale) {
        return "JaCoCo Test Coverage Report.";
    }

    public boolean isExternalReport() {
        return true;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected List<String> getIncludes() {
        return this.includes;
    }

    protected List<String> getExcludes() {
        return this.excludes;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("jacoco") ? new File(reportOutputDirectory, "jacoco") : reportOutputDirectory;
    }

    public boolean canGenerateReport() {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping JaCoCo for project with packaging type 'pom'");
            return false;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping JaCoCo execution");
            return false;
        }
        if (!this.dataFile.exists()) {
            this.getLog().info((CharSequence)"Skipping JaCoCo execution due to missing execution data file");
            return false;
        }
        return true;
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        try {
            this.executeReport(Locale.getDefault());
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.loadExecutionData();
        try {
            IReportVisitor visitor = this.createVisitor(locale);
            visitor.visitInfo(this.sessionInfoStore.getInfos(), this.executionDataStore.getContents());
            this.createReport((IReportGroupVisitor)visitor);
            visitor.visitEnd();
        }
        catch (IOException e) {
            throw new MavenReportException("Error while creating report: " + e.getMessage(), (Exception)e);
        }
    }

    private void loadExecutionData() throws MavenReportException {
        ExecFileLoader loader = new ExecFileLoader();
        try {
            loader.load(this.dataFile);
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to read execution data file " + this.dataFile + ": " + e.getMessage(), (Exception)e);
        }
        this.sessionInfoStore = loader.getSessionInfoStore();
        this.executionDataStore = loader.getExecutionDataStore();
    }

    private void createReport(IReportGroupVisitor visitor) throws IOException {
        FileFilter fileFilter = new FileFilter(this.getIncludes(), this.getExcludes());
        BundleCreator creator = new BundleCreator(this.getProject(), fileFilter);
        IBundleCoverage bundle = creator.createBundle(this.executionDataStore);
        SourceFileCollection locator = new SourceFileCollection(this.getCompileSourceRoots(), this.sourceEncoding);
        this.checkForMissingDebugInformation((ICoverageNode)bundle);
        visitor.visitBundle(bundle, (ISourceFileLocator)locator);
    }

    private void checkForMissingDebugInformation(ICoverageNode node) {
        if (node.getClassCounter().getTotalCount() > 0 && node.getLineCounter().getTotalCount() == 0) {
            this.getLog().warn((CharSequence)"To enable source code annotation class files have to be compiled with debug information.");
        }
    }

    private IReportVisitor createVisitor(Locale locale) throws IOException {
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        this.outputDirectory.mkdirs();
        XMLFormatter xmlFormatter = new XMLFormatter();
        xmlFormatter.setOutputEncoding(this.outputEncoding);
        visitors.add(xmlFormatter.createVisitor((OutputStream)new FileOutputStream(new File(this.outputDirectory, "jacoco.xml"))));
        CSVFormatter csvFormatter = new CSVFormatter();
        csvFormatter.setOutputEncoding(this.outputEncoding);
        visitors.add(csvFormatter.createVisitor((OutputStream)new FileOutputStream(new File(this.outputDirectory, "jacoco.csv"))));
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding(this.outputEncoding);
        htmlFormatter.setLocale(locale);
        visitors.add(htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(this.outputDirectory)));
        return new MultiReportVisitor(visitors);
    }

    private File resolvePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.getProject().getBasedir(), path);
        }
        return file;
    }

    private List<File> getCompileSourceRoots() {
        ArrayList<File> result = new ArrayList<File>();
        for (Object path : this.getProject().getCompileSourceRoots()) {
            result.add(this.resolvePath((String)path));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceFileCollection
    implements ISourceFileLocator {
        private final List<File> sourceRoots;
        private final String encoding;

        public SourceFileCollection(List<File> sourceRoots, String encoding) {
            this.sourceRoots = sourceRoots;
            this.encoding = encoding;
        }

        public Reader getSourceFile(String packageName, String fileName) throws IOException {
            String r = packageName.length() > 0 ? packageName + '/' + fileName : fileName;
            for (File sourceRoot : this.sourceRoots) {
                File file = new File(sourceRoot, r);
                if (!file.exists() || !file.isFile()) continue;
                return new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
            }
            return null;
        }

        public int getTabWidth() {
            return 4;
        }
    }
}

