/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization;

import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.PrimitiveSerializer;
import org.infinispan.server.resp.serialization.Resp3Response;
import org.infinispan.server.resp.serialization.Resp3SerializerRegistry;
import org.infinispan.server.resp.serialization.SerializationHint;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Resp3Type implements SerializationHint.SimpleHint
{
    SIMPLE_STRING{

        @Override
        public void serialize(Object object, ByteBufPool alloc) {
            Resp3Response.simpleString((CharSequence)object, alloc);
        }
    }
    ,
    BULK_STRING{

        @Override
        public void serialize(Object object, ByteBufPool alloc) {
            Resp3SerializerRegistry.serialize(object, alloc, PrimitiveSerializer.BULK_STRING_SERIALIZERS);
        }
    }
    ,
    INTEGER{

        @Override
        public void serialize(Object object, ByteBufPool alloc) {
            Resp3Response.integers((Number)object, alloc);
        }
    }
    ,
    DOUBLE{

        @Override
        public void serialize(Object object, ByteBufPool alloc) {
            Resp3Response.doubles((Number)object, alloc);
        }
    };


    @Override
    public abstract void serialize(Object var1, ByteBufPool var2);
}

