/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.hotrod.Authentication;
import org.infinispan.server.hotrod.CounterRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.MultimapRequestProcessor;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.TaskRequestProcessor;
import org.infinispan.server.hotrod.TransactionRequestProcessor;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.telemetry.InfinispanTelemetry;

abstract class BaseDecoder
extends ByteToMessageDecoder {
    protected static final Log log = (Log)LogFactory.getLog(BaseDecoder.class, Log.class);
    protected final EmbeddedCacheManager cacheManager;
    protected final Executor executor;
    protected final HotRodServer server;
    protected Authentication auth;
    protected TransactionRequestProcessor cacheProcessor;
    protected CounterRequestProcessor counterProcessor;
    protected MultimapRequestProcessor multimapProcessor;
    protected TaskRequestProcessor taskProcessor;

    protected BaseDecoder(EmbeddedCacheManager cacheManager, Executor executor, HotRodServer server) {
        this.cacheManager = cacheManager;
        this.executor = executor;
        this.server = server;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        InfinispanTelemetry telemetryService = (InfinispanTelemetry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cacheManager).getComponent(InfinispanTelemetry.class);
        this.auth = new Authentication(ctx.channel(), this.executor, this.server);
        this.cacheProcessor = new TransactionRequestProcessor(ctx.channel(), this.executor, this.server, telemetryService);
        this.counterProcessor = new CounterRequestProcessor(ctx.channel(), (EmbeddedCounterManager)EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager), this.executor, this.server);
        this.multimapProcessor = new MultimapRequestProcessor(ctx.channel(), this.executor, this.server);
        this.taskProcessor = new TaskRequestProcessor(ctx.channel(), this.executor, this.server);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (log.isTraceEnabled()) {
            log.tracef("Channel %s became active", ctx.channel());
        }
        this.server.getClientListenerRegistry().findAndWriteEvents(ctx.channel());
        this.server.getClientCounterNotificationManager().channelActive(ctx.channel());
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        Channel channel = ctx.channel();
        boolean writeable = channel.isWritable();
        if (log.isTraceEnabled()) {
            log.tracef("Channel %s writability changed to %b", channel, writeable);
        }
        if (writeable) {
            this.server.getClientListenerRegistry().findAndWriteEvents(channel);
            this.server.getClientCounterNotificationManager().channelActive(channel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Exception caught", t);
        }
        if (t instanceof DecoderException) {
            t = t.getCause();
        }
        if (!ctx.channel().isActive() && t instanceof IllegalStateException && t.getMessage().equals("ssl is null")) {
            return;
        }
        this.cacheProcessor.writeException(this.getHeader(), t);
    }

    protected abstract HotRodHeader getHeader();

    protected int defaultExpiration(int duration, int flags, ProtocolFlag defaultFlag) {
        if (duration > 0) {
            return duration;
        }
        return (flags & defaultFlag.getValue()) != 0 ? -2 : -1;
    }

    protected <K, V> Map<K, V> allocMap(int size) {
        return size == 0 ? Collections.emptyMap() : new HashMap(size * 4 / 3, 0.75f);
    }

    protected <T> List<T> allocList(int size) {
        return size == 0 ? Collections.emptyList() : new ArrayList(size);
    }

    protected <T> Set<T> allocSet(int size) {
        return size == 0 ? Collections.emptySet() : new HashSet(size);
    }
}

