/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.mapper.pojo.extractor.ValueProcessor;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorContainerExtractionContext;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public class PojoIndexingProcessorContainerElementNode<C, V>
extends PojoIndexingProcessor<C> {
    private final ContainerExtractorHolder<C, V> extractorHolder;
    private final PojoIndexingProcessor<? super V> nested;
    private final ValueProcessor<DocumentElement, ? super C, PojoIndexingProcessorRootContext> extractingDelegate;

    public PojoIndexingProcessorContainerElementNode(ContainerExtractorHolder<C, V> extractorHolder, PojoIndexingProcessor<? super V> nested) {
        this.extractorHolder = extractorHolder;
        this.nested = nested;
        this.extractingDelegate = extractorHolder.wrap((target, value, sessionContext, extractionContext) -> nested.process((DocumentElement)target, (Object)value, (PojoIndexingProcessorRootContext)sessionContext));
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ContainerExtractorHolder::close, this.extractorHolder);
            closer.push(PojoIndexingProcessor::close, this.nested);
        }
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.attribute("operation", (Object)"process container element");
        appender.attribute("extractor", this.extractorHolder);
        appender.attribute("nested", this.nested);
    }

    @Override
    public final void process(DocumentElement target, C source, PojoIndexingProcessorRootContext context) {
        this.extractingDelegate.process(target, (PojoIndexingProcessorRootContext)source, context, PojoIndexingProcessorContainerExtractionContext.INSTANCE);
    }
}

