/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.loading.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingStrategy;

final class PojoSingleLoaderLoadingPlan<T>
implements PojoLoadingPlan<T> {
    private final PojoSelectionLoadingContext context;
    private final PojoSelectionLoadingStrategy<T> loadingStrategy;
    private final Set<PojoLoadingTypeContext<? extends T>> expectedTypes = new LinkedHashSet<PojoLoadingTypeContext<? extends T>>();
    private final List<Object> identifiers = new ArrayList<Object>();
    private boolean singleConcreteTypeInEntityHierarchy;
    private List<T> loaded;

    PojoSingleLoaderLoadingPlan(PojoSelectionLoadingContext context, PojoSelectionLoadingStrategy<T> loadingStrategy) {
        this.context = context;
        this.loadingStrategy = loadingStrategy;
    }

    @Override
    public <T2 extends T> int planLoading(PojoLoadingTypeContext<T2> expectedType, Object identifier) {
        this.expectedTypes.add(expectedType);
        this.identifiers.add(identifier);
        return this.identifiers.size() - 1;
    }

    @Override
    public void loadBlocking(Deadline deadline) {
        this.context.checkOpen();
        if (this.identifiers.isEmpty()) {
            return;
        }
        try {
            PojoSelectionEntityLoader<T> loader = this.loadingStrategy.createEntityLoader(this.expectedTypes, this.context);
            this.singleConcreteTypeInEntityHierarchy = this.expectedTypes.size() == 1 && this.expectedTypes.iterator().next().isSingleConcreteTypeInEntityHierarchy();
            this.loaded = loader.loadBlocking(this.identifiers, deadline);
        }
        finally {
            this.expectedTypes.clear();
            this.identifiers.clear();
        }
    }

    @Override
    public <T2 extends T> T2 retrieve(PojoLoadingTypeContext<T2> expectedType, int ordinal) {
        T retrieved = this.loaded.get(ordinal);
        if (retrieved == null) {
            return null;
        }
        return this.castToExactTypeOrNull(expectedType, retrieved);
    }

    @Override
    public void clear() {
        this.expectedTypes.clear();
        this.identifiers.clear();
        this.loaded = null;
    }

    private <T2 extends T> T2 castToExactTypeOrNull(PojoLoadingTypeContext<T2> expectedType, T loadedObject) {
        if (this.singleConcreteTypeInEntityHierarchy) {
            return (T2)loadedObject;
        }
        if (expectedType.typeIdentifier().equals(this.context.runtimeIntrospector().detectEntityType(loadedObject))) {
            return (T2)loadedObject;
        }
        return null;
    }
}

