/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.identity.impl;

import java.util.Map;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.identity.impl.AbstractIdentityMappingCollectorNode;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingCollectorValueNode;
import org.hibernate.search.mapper.pojo.identity.impl.PojoIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;

class IdentityMappingCollectorPropertyNode<P>
extends AbstractIdentityMappingCollectorNode
implements PojoIndexMappingCollectorPropertyNode {
    private final BoundPojoModelPathPropertyNode<?, P> modelPath;
    private final PojoIdentityMappingCollector identityMappingCollector;

    IdentityMappingCollectorPropertyNode(BoundPojoModelPathPropertyNode<?, P> modelPath, PojoMappingHelper mappingHelper, PojoIdentityMappingCollector identityMappingCollector) {
        super(mappingHelper);
        this.modelPath = modelPath;
        this.identityMappingCollector = identityMappingCollector;
    }

    @Override
    BoundPojoModelPath getModelPath() {
        return this.modelPath;
    }

    @Override
    public void propertyBinder(PropertyBinder binder, Map<String, Object> params) {
    }

    @Override
    public void identifierBinder(IdentifierBinder binder, Map<String, Object> params) {
        this.identityMappingCollector.identifierBridge(this.modelPath, binder, params);
    }

    @Override
    public PojoIndexMappingCollectorValueNode value(ContainerExtractorPath extractorPath) {
        BoundContainerExtractorPath<P, ?> boundExtractorPath = this.mappingHelper.indexModelBinder().bindExtractorPath(this.modelPath.getPropertyModel().typeModel(), extractorPath);
        return new IdentityMappingCollectorValueNode(this.modelPath.value(boundExtractorPath), this.mappingHelper);
    }
}

