/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.spi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanRetrieval;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorConfigurationContext;
import org.hibernate.search.mapper.pojo.extractor.builtin.BuiltinContainerExtractors;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.BooleanArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.ByteArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.CharArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.CollectionElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.DoubleArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.FloatArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.IntArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.IterableElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.LongArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.MapKeyExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.MapValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.ObjectArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalDoubleValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalIntValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalLongValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.ShortArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.spi.ContainerExtractorDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ContainerExtractorRegistry {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, ContainerExtractorDefinition<? extends ContainerExtractor>> extractorsByName = new HashMap<String, ContainerExtractorDefinition<? extends ContainerExtractor>>();
    private final List<String> defaultExtractors = new ArrayList<String>();

    public static Builder builder() {
        return new Builder();
    }

    private ContainerExtractorRegistry(Map<String, ContainerExtractorDefinition<? extends ContainerExtractor>> customExtractorsByName) {
        this.extractorsByName.putAll(customExtractorsByName);
        this.addDefaultExtractor("map-value", MapValueExtractor.class);
        this.addDefaultExtractor("collection", CollectionElementExtractor.class);
        this.addDefaultExtractor("iterable", IterableElementExtractor.class);
        this.addDefaultExtractor("optional", OptionalValueExtractor.class);
        this.addDefaultExtractor("optional-int", OptionalIntValueExtractor.class);
        this.addDefaultExtractor("optional-long", OptionalLongValueExtractor.class);
        this.addDefaultExtractor("optional-double", OptionalDoubleValueExtractor.class);
        this.addDefaultExtractor("array-char", CharArrayElementExtractor.class);
        this.addDefaultExtractor("array-boolean", BooleanArrayElementExtractor.class);
        this.addDefaultExtractor("array-byte", ByteArrayElementExtractor.class);
        this.addDefaultExtractor("array-short", ShortArrayElementExtractor.class);
        this.addDefaultExtractor("array-int", IntArrayElementExtractor.class);
        this.addDefaultExtractor("array-long", LongArrayElementExtractor.class);
        this.addDefaultExtractor("array-float", FloatArrayElementExtractor.class);
        this.addDefaultExtractor("array-double", DoubleArrayElementExtractor.class);
        this.addDefaultExtractor("array-object", ObjectArrayElementExtractor.class);
        this.addNonDefaultExtractor("map-key", MapKeyExtractor.class);
    }

    public List<String> defaults() {
        return Collections.unmodifiableList(this.defaultExtractors);
    }

    public ContainerExtractorDefinition<?> forName(String name) {
        ContainerExtractorDefinition<? extends ContainerExtractor> result = this.extractorsByName.get(name);
        if (result == null) {
            throw log.cannotResolveContainerExtractorName(name, BuiltinContainerExtractors.class);
        }
        return result;
    }

    private <C extends ContainerExtractor> void addDefaultExtractor(String name, Class<C> extractorClass) {
        this.addNonDefaultExtractor(name, extractorClass);
        this.defaultExtractors.add(name);
    }

    private <C extends ContainerExtractor> void addNonDefaultExtractor(String name, Class<C> extractorClass) {
        this.extractorsByName.put(name, new ContainerExtractorDefinition<C>(extractorClass, BeanReference.of(extractorClass, (BeanRetrieval)BeanRetrieval.CONSTRUCTOR)));
    }

    public static final class Builder
    implements ContainerExtractorConfigurationContext {
        private final Map<String, ContainerExtractorDefinition<?>> extractorsByName = new HashMap();

        private Builder() {
        }

        @Override
        public void define(String extractorName, Class<? extends ContainerExtractor> extractorClass) {
            this.doDefine(extractorName, extractorClass);
        }

        private <C extends ContainerExtractor> void doDefine(String extractorName, Class<C> extractorClass) {
            this.define(extractorName, extractorClass, BeanReference.of(extractorClass, (BeanRetrieval)BeanRetrieval.CONSTRUCTOR));
        }

        @Override
        public <C extends ContainerExtractor> void define(String extractorName, Class<C> extractorClass, BeanReference<? extends C> reference) {
            this.extractorsByName.put(extractorName, new ContainerExtractorDefinition<C>(extractorClass, reference));
        }

        public ContainerExtractorRegistry build() {
            return new ContainerExtractorRegistry(this.extractorsByName);
        }
    }
}

