/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.impl;

import java.util.BitSet;
import java.util.List;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingAssociationInverseSideResolverNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingAssociationInverseSideResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingAssociationInverseSideCollector;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathOrdinals;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public final class PojoImplicitReindexingAssociationInverseSideResolver
implements AutoCloseable,
ToStringTreeAppendable {
    private final PojoPathOrdinals pathOrdinals;
    private final PojoPathFilter dirtyContainingAssociationFilter;
    private final List<List<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>>> resolversByOrdinal;

    public PojoImplicitReindexingAssociationInverseSideResolver(PojoPathOrdinals pathOrdinals, PojoPathFilter dirtyContainingAssociationFilter, List<List<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>>> resolversByOrdinal) {
        this.pathOrdinals = pathOrdinals;
        this.dirtyContainingAssociationFilter = dirtyContainingAssociationFilter;
        this.resolversByOrdinal = resolversByOrdinal;
    }

    public String toString() {
        return this.toStringTree();
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.attribute("dirtyContainingAssociationFilter", (Object)this.dirtyContainingAssociationFilter);
        appender.startObject("resolversByAssociationPath");
        for (int i = 0; i < this.resolversByOrdinal.size(); ++i) {
            List<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>> resolvers = this.resolversByOrdinal.get(i);
            if (resolvers == null) continue;
            appender.attribute(this.pathOrdinals.toPath(i), resolvers);
        }
        appender.endObject();
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            for (List<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>> ordinalList : this.resolversByOrdinal) {
                closer.pushAll(PojoImplicitReindexingAssociationInverseSideResolverNode::close, ordinalList);
            }
        }
    }

    public PojoPathFilter dirtyContainingAssociationFilter() {
        return this.dirtyContainingAssociationFilter;
    }

    public void resolveEntitiesToReindex(PojoReindexingAssociationInverseSideCollector collector, BitSet dirtyAssociationPaths, Object[] oldState, Object[] newState, PojoImplicitReindexingAssociationInverseSideResolverRootContext context) {
        int resolverSize = this.resolversByOrdinal.size();
        int i = dirtyAssociationPaths.nextSetBit(0);
        while (i >= 0 && i < resolverSize) {
            for (PojoImplicitReindexingAssociationInverseSideResolverNode<Object> resolver : this.resolversByOrdinal.get(i)) {
                if (oldState != null) {
                    resolver.resolveEntitiesToReindex(collector, oldState[i], context);
                }
                if (newState == null) continue;
                resolver.resolveEntitiesToReindex(collector, newState[i], context);
            }
            i = dirtyAssociationPaths.nextSetBit(i + 1);
        }
    }
}

