/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import java.lang.reflect.Array;
import java.util.List;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.ListBasedProjectionCollector;

final class ArrayProjectionCollector<E, V>
extends ListBasedProjectionCollector<E, V, V[]> {
    private final Class<? super V> elementType;

    static <U, R> ProjectionCollector.Provider<U, R> provider(Class<? super U> elementType) {
        return new ArrayProvider(elementType);
    }

    private ArrayProjectionCollector(Class<? super V> elementType) {
        this.elementType = elementType;
    }

    @Override
    public V[] doFinish(List<V> accumulated) {
        Object[] array = (Object[])Array.newInstance(this.elementType, accumulated.size());
        int i = 0;
        for (V v : accumulated) {
            array[i++] = v;
        }
        return array;
    }

    private static class ArrayProvider<U, R>
    implements ProjectionCollector.Provider<U, R> {
        private final ArrayProjectionCollector<?, U> instance;

        private ArrayProvider(Class<? super U> elementType) {
            this.instance = new ArrayProjectionCollector(elementType);
        }

        @Override
        public <T> ProjectionCollector<T, U, ?, R> get() {
            return this.instance;
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }
    }
}

