/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTemplateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaNamedPredicateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaObjectField;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaObjectFieldImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexCompositeNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexObjectFieldBuilder;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFinalStep;
import org.hibernate.search.engine.common.tree.spi.TreeNestingContext;
import org.hibernate.search.engine.logging.impl.MappingLog;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinition;
import org.hibernate.search.engine.search.predicate.definition.TypedPredicateDefinition;
import org.hibernate.search.util.common.impl.StringHelper;

public class IndexSchemaElementImpl<B extends IndexCompositeNodeBuilder>
implements IndexSchemaElement {
    private final IndexFieldTypeFactory typeFactory;
    final B objectNodeBuilder;
    private final TreeNestingContext nestingContext;
    private final boolean directChildrenAreMultiValuedByDefault;

    public IndexSchemaElementImpl(IndexFieldTypeFactory typeFactory, B objectNodeBuilder, TreeNestingContext nestingContext, boolean directChildrenAreMultiValuedByDefault) {
        this.typeFactory = typeFactory;
        this.objectNodeBuilder = objectNodeBuilder;
        this.nestingContext = nestingContext;
        this.directChildrenAreMultiValuedByDefault = directChildrenAreMultiValuedByDefault;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "objectNodeBuilder=" + this.objectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> field(String relativeFieldName, IndexFieldType<F> type) {
        this.checkRelativeFieldName(relativeFieldName);
        IndexSchemaFieldOptionsStep fieldFinalStep = this.nestingContext.nest(relativeFieldName, (prefixedName, inclusion) -> this.objectNodeBuilder.addField(prefixedName, inclusion, type));
        if (this.directChildrenAreMultiValuedByDefault) {
            fieldFinalStep.multiValued();
        }
        return fieldFinalStep;
    }

    @Override
    public IndexSchemaNamedPredicateOptionsStep namedPredicate(String relativeNamedPredicateName, PredicateDefinition definition) {
        this.checkRelativeNamedPredicateName(relativeNamedPredicateName);
        return this.nestingContext.nestUnfiltered((inclusion, prefix) -> this.objectNodeBuilder.addNamedPredicate(relativeNamedPredicateName, inclusion, definition));
    }

    @Override
    public IndexSchemaNamedPredicateOptionsStep namedPredicate(String relativeNamedPredicateName, TypedPredicateDefinition<?> definition) {
        this.checkRelativeNamedPredicateName(relativeNamedPredicateName);
        return this.nestingContext.nestUnfiltered((inclusion, prefix) -> this.objectNodeBuilder.addNamedPredicate(relativeNamedPredicateName, inclusion, definition));
    }

    @Override
    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> field(String relativeFieldName, Function<? super IndexFieldTypeFactory, ? extends IndexFieldTypeFinalStep<F>> typeContributor) {
        return this.field(relativeFieldName, typeContributor.apply(this.typeFactory));
    }

    @Override
    public IndexSchemaObjectField objectField(String relativeFieldName, ObjectStructure structure) {
        this.checkRelativeFieldName(relativeFieldName);
        IndexSchemaObjectField objectField = this.nestingContext.nest(relativeFieldName, (prefixedName, inclusion, nestedNestingContext) -> {
            IndexObjectFieldBuilder objectFieldBuilder = this.objectNodeBuilder.addObjectField(prefixedName, inclusion, structure);
            return new IndexSchemaObjectFieldImpl(this.typeFactory, objectFieldBuilder, nestedNestingContext, false);
        });
        if (this.directChildrenAreMultiValuedByDefault) {
            objectField.multiValued();
        }
        return objectField;
    }

    @Override
    public IndexSchemaFieldTemplateOptionsStep<?> fieldTemplate(String templateName, IndexFieldType<?> type) {
        this.checkFieldTemplateName(templateName);
        IndexSchemaFieldTemplateOptionsStep fieldTemplateFinalStep = this.nestingContext.nestUnfiltered((inclusion, prefix) -> this.objectNodeBuilder.addFieldTemplate(templateName, inclusion, type, prefix));
        if (this.directChildrenAreMultiValuedByDefault) {
            fieldTemplateFinalStep.multiValued();
        }
        return fieldTemplateFinalStep;
    }

    @Override
    public IndexSchemaFieldTemplateOptionsStep<?> fieldTemplate(String templateName, Function<? super IndexFieldTypeFactory, ? extends IndexFieldTypeFinalStep<?>> typeContributor) {
        return this.fieldTemplate(templateName, typeContributor.apply(this.typeFactory));
    }

    @Override
    public IndexSchemaFieldTemplateOptionsStep<?> objectFieldTemplate(String templateName, ObjectStructure structure) {
        this.checkFieldTemplateName(templateName);
        IndexSchemaFieldTemplateOptionsStep fieldTemplateFinalStep = this.nestingContext.nestUnfiltered((inclusion, prefix) -> this.objectNodeBuilder.addObjectFieldTemplate(templateName, structure, prefix, inclusion));
        if (this.directChildrenAreMultiValuedByDefault) {
            fieldTemplateFinalStep.multiValued();
        }
        return fieldTemplateFinalStep;
    }

    private void checkRelativeFieldName(String relativeFieldName) {
        if (StringHelper.isEmpty((String)relativeFieldName)) {
            throw MappingLog.INSTANCE.relativeFieldNameCannotBeNullOrEmpty(relativeFieldName, this.objectNodeBuilder.eventContext());
        }
        if (relativeFieldName.contains(FieldPaths.PATH_SEPARATOR_STRING)) {
            throw MappingLog.INSTANCE.relativeFieldNameCannotContainDot(relativeFieldName, this.objectNodeBuilder.eventContext());
        }
    }

    private void checkFieldTemplateName(String templateName) {
        if (StringHelper.isEmpty((String)templateName)) {
            throw MappingLog.INSTANCE.fieldTemplateNameCannotBeNullOrEmpty(templateName, this.objectNodeBuilder.eventContext());
        }
        if (templateName.contains(FieldPaths.PATH_SEPARATOR_STRING)) {
            throw MappingLog.INSTANCE.fieldTemplateNameCannotContainDot(templateName, this.objectNodeBuilder.eventContext());
        }
    }

    private void checkRelativeNamedPredicateName(String relativeFilterName) {
        if (StringHelper.isEmpty((String)relativeFilterName)) {
            throw MappingLog.INSTANCE.relativeNamedPredicateNameCannotBeNullOrEmpty(relativeFilterName, this.objectNodeBuilder.eventContext());
        }
        if (relativeFilterName.contains(".")) {
            throw MappingLog.INSTANCE.relativeNamedPredicateNameCannotContainDot(relativeFilterName, this.objectNodeBuilder.eventContext());
        }
    }
}

