/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.resources.spi;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.spi.ClosingOperator;

public class SavedState
implements AutoCloseable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final SavedState EMPTY = new Builder().build();
    private final Map<Key<?>, SavedValue<?, ?>> content;

    public static SavedState empty() {
        return EMPTY;
    }

    private SavedState(Builder builder) {
        this.content = builder.content;
    }

    public <T> Optional<T> get(Key<T> key) {
        SavedValue<?, ?> savedValue = this.content.get(key);
        if (savedValue == null) {
            return Optional.empty();
        }
        Object value = savedValue.value();
        return Optional.ofNullable(value);
    }

    public static <T> Key<T> key(String name) {
        Contracts.assertNotNullNorEmpty((String)name, (String)"name");
        return new Key(name);
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(entry -> ((SavedValue)entry.getValue()).close((Key)entry.getKey()), this.content.entrySet());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void closeAll(Map<?, SavedState> map) {
        try (Closer closer = new Closer();){
            closer.pushAll(entry -> {
                try {
                    ((SavedState)entry.getValue()).close();
                }
                catch (RuntimeException e) {
                    throw log.unableToCloseSavedValue(Throwables.safeToString((Throwable)e, (Object)entry.toString()), e.getMessage(), e);
                }
            }, map.entrySet());
        }
    }

    public static final class Builder {
        private final Map<Key<?>, SavedValue<?, ?>> content = new LinkedHashMap();

        private Builder() {
        }

        public Builder put(Key<SavedState> key, SavedState value) {
            return this.put(key, value, SavedState::close);
        }

        public Builder put(Key<Map<String, SavedState>> key, Map<String, SavedState> value) {
            return this.put(key, value, x$0 -> SavedState.closeAll(x$0));
        }

        public <T> Builder put(Key<T> key, T value, ClosingOperator<T, ? extends Exception> closingOperator) {
            this.content.put(key, new SavedValue(value, closingOperator));
            return this;
        }

        public SavedState build() {
            return new SavedState(this);
        }
    }

    public static final class SavedValue<T, E extends Exception> {
        private final T value;
        private final ClosingOperator<T, ? extends Exception> closingOperator;
        private boolean close = true;

        public SavedValue(T value, ClosingOperator<T, ? extends Exception> closingOperator) {
            this.value = value;
            this.closingOperator = closingOperator;
        }

        public T value() {
            this.close = false;
            return this.value;
        }

        public void close(Key<?> key) {
            if (!this.close) {
                return;
            }
            try {
                this.closingOperator.close(this.value);
            }
            catch (Exception e) {
                throw log.unableToCloseSavedValue(key.name, e.getMessage(), e);
            }
        }
    }

    public static final class Key<T> {
        private final String name;

        private Key(String name) {
            this.name = name;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.name, key.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

