/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.sort.impl;

import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneCompositeSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneIndexOrderSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneScoreSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneUserProvidedLuceneSortFieldSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneUserProvidedLuceneSortSort;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;
import org.hibernate.search.engine.search.sort.spi.ScoreSortBuilder;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;

public class LuceneSearchSortBuilderFactory
implements SearchSortBuilderFactory {
    private final LuceneSearchIndexScope<?> scope;

    public LuceneSearchSortBuilderFactory(LuceneSearchIndexScope<?> scope) {
        this.scope = scope;
    }

    public ScoreSortBuilder score() {
        return new LuceneScoreSort.Builder(this.scope);
    }

    public SearchSort indexOrder() {
        return new LuceneIndexOrderSort(this.scope);
    }

    public CompositeSortBuilder composite() {
        return new LuceneCompositeSort.Builder(this.scope);
    }

    public LuceneSearchSort fromLuceneSortField(SortField luceneSortField) {
        return new LuceneUserProvidedLuceneSortFieldSort(this.scope, luceneSortField);
    }

    public LuceneSearchSort fromLuceneSort(Sort luceneSort) {
        return new LuceneUserProvidedLuceneSortSort(this.scope, luceneSort);
    }
}

