/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hikaricp.internal;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.hikaricp.internal.HikariConfigurationUtil;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class HikariCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -9131625057941275711L;
    private HikariConfig hcfg = null;
    private HikariDataSource hds = null;

    public void configure(Map<String, Object> props) throws HibernateException {
        try {
            ConnectionInfoLogger.INSTANCE.configureConnectionPool("HikariCP");
            this.hcfg = HikariConfigurationUtil.loadConfiguration(props);
            this.hds = new HikariDataSource(this.hcfg);
        }
        catch (Exception e) {
            ConnectionInfoLogger.INSTANCE.unableToInstantiateConnectionPool(e);
            throw new HibernateException((Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.hds != null ? this.hds.getConnection() : null;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return new DatabaseConnectionInfoImpl(this.hcfg.getJdbcUrl(), this.hcfg.getDriverClassName(), dialect.getVersion(), Boolean.toString(this.hcfg.isAutoCommit()), this.hcfg.getTransactionIsolation(), Integer.valueOf(this.hcfg.getMinimumIdle()), Integer.valueOf(this.hcfg.getMaximumPoolSize()));
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return ConnectionProvider.class.equals(unwrapType) || HikariCPConnectionProvider.class.isAssignableFrom(unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || HikariCPConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.hds;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        if (this.hds != null) {
            ConnectionInfoLogger.INSTANCE.cleaningUpConnectionPool("HikariCP");
            this.hds.close();
        }
    }
}

