/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.search.query.engine.spi.EntityInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInfoImpl
implements EntityInfo {
    private final Class<?> clazz;
    private final Serializable id;
    private final String idName;
    private final Object[] projection;
    private final List<Integer> indexesOfThis = new LinkedList<Integer>();

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    @Override
    public String getIdName() {
        return this.idName;
    }

    @Override
    public Object[] getProjection() {
        return this.projection;
    }

    @Override
    public List<Integer> getIndexesOfThis() {
        return this.indexesOfThis;
    }

    @Override
    public boolean isProjectThis() {
        return this.indexesOfThis.size() != 0;
    }

    @Override
    public void populateWithEntityInstance(Object entity) {
        for (int index : this.indexesOfThis) {
            this.projection[index] = entity;
        }
    }

    public EntityInfoImpl(Class clazz, String idName, Serializable id, Object[] projection) {
        this.clazz = clazz;
        this.idName = idName;
        this.id = id;
        this.projection = projection != null ? (Object[])projection.clone() : null;
    }
}

