/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.QueryTimeoutException;
import org.hibernate.search.SearchException;

public class TimeoutManager {
    private Long timeout;
    private long start;
    boolean timedOut = false;
    private Query luceneQuery;
    private Type type;
    private boolean partialResults;

    public void start(Query luceneQuery) {
        if (this.timeout == null) {
            return;
        }
        this.luceneQuery = luceneQuery;
        this.start = System.nanoTime();
        this.partialResults = false;
    }

    public Long getTimeoutLeftInMilliseconds() {
        return this.getTimeoutLeft(1000000L);
    }

    public Long getTimeoutLeftInSeconds() {
        return this.getTimeoutLeft(1000000000L);
    }

    private Long getTimeoutLeft(long factor) {
        if (this.timeout == null) {
            return null;
        }
        long currentTime = System.nanoTime();
        if (this.isTimedOut(currentTime)) {
            return 0L;
        }
        long left = this.timeout - (currentTime - this.start);
        long result = left % factor == 0L ? left / factor : left / factor + 1L;
        if (result <= 0L) {
            return 0L;
        }
        return result;
    }

    public boolean isTimedOut() {
        if (this.timeout == null) {
            return false;
        }
        if (this.timedOut) {
            return true;
        }
        return this.isTimedOut(System.nanoTime());
    }

    private boolean isTimedOut(long currentTime) {
        if (this.timeout == null) {
            return false;
        }
        if (this.timedOut) {
            return true;
        }
        long elapsedTime = currentTime - this.start;
        boolean bl = this.timedOut = elapsedTime > this.timeout;
        if (this.type != Type.LIMIT) {
            throw new QueryTimeoutException("Full-text query took longer than expected (in microsecond): " + TimeUnit.NANOSECONDS.toMicros(elapsedTime), (SQLException)null, this.luceneQuery.toString());
        }
        return this.timedOut;
    }

    public void stop() {
        this.timeout = null;
        this.type = Type.NONE;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toNanos(timeout);
        if (timeout == 0L) {
            this.stop();
        }
    }

    public void forceTimedOut() {
        this.timedOut = Boolean.TRUE;
        if (this.type == Type.LIMIT) {
            this.partialResults = true;
        }
    }

    public void raiseExceptionOnTimeout() {
        if (this.type == Type.LIMIT) {
            throw new SearchException("Cannot define both setTimeout and limitFetchingTime on a full-text query. Please report your need to the Hibernate team");
        }
        this.type = Type.EXCEPTION;
    }

    public void limitFetchingOnTimeout() {
        if (this.type == Type.EXCEPTION) {
            throw new SearchException("Cannot define both setTimeout and limitFetchingTime on a full-text query. Please report your need to the Hibernate team");
        }
        this.type = Type.LIMIT;
    }

    public void reactOnQueryTimeoutExceptionWhileExtracting(QueryTimeoutException e) {
        if (this.type != Type.LIMIT) {
            if (e == null) {
                e = new QueryTimeoutException("Timeout period exceeded", (SQLException)null, this.luceneQuery.toString());
            }
            throw e;
        }
        this.partialResults = true;
    }

    public boolean hasPartialResults() {
        return this.partialResults;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE,
        EXCEPTION,
        LIMIT;

    }
}

