/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.ObjectLoaderBuilder;
import org.hibernate.search.query.TimeoutManager;
import org.hibernate.transform.ResultTransformer;

public class ProjectionLoader
implements Loader {
    private Loader objectLoader;
    private Boolean projectThis;
    private ResultTransformer transformer;
    private String[] aliases;
    private ObjectLoaderBuilder loaderBuilder;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager) {
    }

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ResultTransformer transformer, ObjectLoaderBuilder loaderBuilder, String[] aliases, TimeoutManager timeoutManager) {
        this.init(session, searchFactoryImplementor, timeoutManager);
        this.transformer = transformer;
        this.aliases = aliases;
        this.loaderBuilder = loaderBuilder;
    }

    public Object load(EntityInfo entityInfo) {
        this.initThisProjectionFlag(entityInfo);
        if (this.projectThis.booleanValue()) {
            for (int index : entityInfo.indexesOfThis) {
                entityInfo.projection[index] = this.objectLoader.load(entityInfo);
            }
        }
        if (this.transformer != null) {
            return this.transformer.transformTuple(entityInfo.projection, this.aliases);
        }
        return entityInfo.projection;
    }

    public Object loadWithoutTiming(EntityInfo entityInfo) {
        throw new AssertionFailure("This method is not meant to be used on ProjectionLoader");
    }

    private void initThisProjectionFlag(EntityInfo entityInfo) {
        if (this.projectThis == null) {
            this.projectThis = entityInfo.indexesOfThis.size() != 0;
            if (this.projectThis.booleanValue()) {
                this.objectLoader = this.loaderBuilder.buildLoader();
            }
        }
    }

    public List load(EntityInfo ... entityInfos) {
        ArrayList<Object> results = new ArrayList<Object>(entityInfos.length);
        if (entityInfos.length == 0) {
            return results;
        }
        this.initThisProjectionFlag(entityInfos[0]);
        if (this.projectThis.booleanValue()) {
            this.objectLoader.load(entityInfos);
            for (EntityInfo entityInfo : entityInfos) {
                for (int index : entityInfo.indexesOfThis) {
                    entityInfo.projection[index] = this.objectLoader.loadWithoutTiming(entityInfo);
                }
            }
        }
        for (EntityInfo entityInfo : entityInfos) {
            if (this.transformer != null) {
                results.add(this.transformer.transformTuple(entityInfo.projection, this.aliases));
                continue;
            }
            results.add(entityInfo.projection);
        }
        return results;
    }
}

