/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class Executors {
    private static final String THREAD_GROUP_PREFIX = "Hibernate Search: ";
    private static final int QUEUE_MAX_LENGTH = 1000;
    private static final Logger log = LoggerFactory.make();

    public static ThreadPoolExecutor newFixedThreadPool(int threads, String groupname) {
        return Executors.newFixedThreadPool(threads, groupname, 1000);
    }

    public static ThreadPoolExecutor newFixedThreadPool(int threads, String groupname, int queueSize) {
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new SearchThreadFactory(groupname), new BlockPolicy());
    }

    public static class BlockPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            try {
                e.getQueue().put(r);
            }
            catch (InterruptedException e1) {
                log.error("Work discarded, thread was interrupted while waiting for space to schedule: {}", (Object)r);
            }
        }
    }

    private static class SearchThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        SearchThreadFactory(String groupname) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = Executors.THREAD_GROUP_PREFIX + groupname + "-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            return t;
        }
    }
}

