/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Filter;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.query.dsl.v2.TermContext;
import org.hibernate.search.query.dsl.v2.TermMatchingContext;
import org.hibernate.search.query.dsl.v2.impl.ConnectedTermMatchingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;

class ConnectedTermContext
implements TermContext {
    private final SearchFactory factory;
    private final Analyzer queryAnalyzer;
    private final QueryCustomizer queryCustomizer;
    private final QueryContext context;

    public ConnectedTermContext(Analyzer queryAnalyzer, SearchFactory factory) {
        this.factory = factory;
        this.queryAnalyzer = queryAnalyzer;
        this.queryCustomizer = new QueryCustomizer();
        this.context = new QueryContext(QueryContext.Approximation.EXACT);
    }

    public TermMatchingContext onField(String field) {
        return new ConnectedTermMatchingContext(this.context, field, this.queryCustomizer, this.queryAnalyzer, this.factory);
    }

    public TermMatchingContext onFields(String ... fields) {
        return new ConnectedTermMatchingContext(this.context, fields, this.queryCustomizer, this.queryAnalyzer, this.factory);
    }

    public TermContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    public TermContext constantScore() {
        this.queryCustomizer.constantScore();
        return this;
    }

    public TermContext filter(Filter filter) {
        this.queryCustomizer.filter(filter);
        return this;
    }
}

