/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.analysis.TokenizerFactory;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldBridgeMapping;
import org.hibernate.search.cfg.FullTextFilterDefMapping;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvidedIdMapping {
    private final SearchMapping searchMapping;
    private final Map<String, Object> providedIdMapping;
    private EntityDescriptor entity;

    public ProvidedIdMapping(SearchMapping searchMapping, EntityDescriptor entity) {
        this.searchMapping = searchMapping;
        this.entity = entity;
        this.providedIdMapping = new HashMap<String, Object>();
        entity.setProvidedId(this.providedIdMapping);
    }

    public ProvidedIdMapping name(String name) {
        this.providedIdMapping.put("name", name);
        return this;
    }

    public FieldBridgeMapping bridge(Class<?> impl) {
        return new FieldBridgeMapping(impl, this.providedIdMapping, null, null, this.entity, this.searchMapping);
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this.searchMapping, name, impl);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.searchMapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.searchMapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.searchMapping);
    }
}

