/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.hibernate.search.util.logging.impl.IndexedTypeIdentifierFormatter;
import org.hibernate.search.util.logging.impl.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BaseHibernateSearchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String initializedBlackholeBackend = "HSEARCH000001: initialized \"blackhole\" backend. Index changes will be prepared but discarded!";
    private static final String closedBlackholeBackend = "HSEARCH000002: closed \"blackhole\" backend.";
    private static final String incorrectMessageType = "HSEARCH000016: Incorrect message type: %1$s";
    private static final String interruptedWorkError = "HSEARCH000017: Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    private static final String skippingDirectorySynchronization = "HSEARCH000018: Skipping directory synchronization, previous work still in progress: %1$s";
    private static final String unableToRemovePreviousMarker = "HSEARCH000019: Unable to remove previous marker file from source of %1$s";
    private static final String unableToCreateCurrentMarker = "HSEARCH000020: Unable to create current marker in source of %1$s";
    private static final String unableToSynchronizeSource = "HSEARCH000021: Unable to synchronize source of %1$s";
    private static final String unableToDetermineCurrentInSourceDirectory = "HSEARCH000022: Unable to determine current in source directory, will try again during the next synchronization";
    private static final String unableToCompareSourceWithDestinationDirectory = "HSEARCH000023: Unable to compare %1$s with %2$s.";
    private static final String idCannotBeExtracted = "HSEARCH000024: Unable to reindex entity on collection change, id cannot be extracted: %1$s";
    private static final String serviceProviderNotReleased = "HSEARCH000025: Service provider has been used but not released: %1$s";
    private static final String stopServiceFailed = "HSEARCH000026: Fail to properly stop service: %1$s";
    private static final String indexingEntities = "HSEARCH000027: Going to reindex %d entities";
    private static final String indexingEntitiesCompleted = "HSEARCH000028: Reindexed %1$d entities";
    private static final String indexingCompletedAndMBeanUnregistered = "HSEARCH000029: Indexing completed. Reindexed %1$d entities. Unregistering MBean from server";
    private static final String indexingDocumentsCompleted = "HSEARCH000030: %1$d documents indexed in %2$d ms";
    private static final String indexingSpeed = "HSEARCH000031: Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    private static final String notDeleted = "HSEARCH000032: Could not delete %1$s";
    private static final String version = "HSEARCH000034: Hibernate Search %1$s";
    private static final String couldNotCloseResource = "HSEARCH000035: Could not close resource.";
    private static final String cannotGuessTransactionStatus = "HSEARCH000036: Cannot guess the Transaction Status: not starting a JTA transaction";
    private static final String unableToCloseSearcherDuringQuery = "HSEARCH000037: Unable to properly close searcher during lucene query: %1$s";
    private static final String forceToUseDocumentExtraction = "HSEARCH000038: Forced to use Document extraction to workaround FieldCache bug in Lucene";
    private static final String unableToCloseSearcherInScrollableResult = "HSEARCH000039: Unable to properly close searcher in ScrollableResults";
    private static final String unexpectedValueMissingFromFieldCache = "HSEARCH000040: Unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.";
    private static final String indexDirectoryNotFoundCreatingNewOne = "HSEARCH000041: Index directory not found, creating: '%1$s'";
    private static final String noCurrentMarkerInSourceDirectory = "HSEARCH000042: No current marker in source directory. Has the master being started already?";
    private static final String foundCurrentMarker = "HSEARCH000043: Found current marker in source directory - initialization succeeded";
    private static final String abstractClassesCannotInsertDocuments = "HSEARCH000044: Abstract classes cannot be indexed directly. Only concrete subclasses can be indexed. @Indexed on '%s' is superfluous and should be removed.";
    private static final String containedInPointsToProvidedId = "HSEARCH000045: @ContainedIn is pointing to an entity having @ProvidedId: %1$s. This is not supported, indexing of contained in entities will be skipped. Indexed data of the embedded object might become out of date in objects of type ";
    private static final String cannotExtractValueForIdentifier = "HSEARCH000046: FieldCache was enabled on class %1$s but for this type of identifier we can't extract values from the FieldCache: cache disabled";
    private static final String unableToCloseJmsConnection = "HSEARCH000047: Unable to close JMS connection for %1$s";
    private static final String unableToRetrieveNamedAnalyzer = "HSEARCH000048: Unable to retrieve named analyzer: %1$s";
    private static final String pushedChangesOutOfTransaction = "HSEARCH000050: It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!";
    private static final String forcingReleaseIndexWriterLock = "HSEARCH000052: Going to force release of the IndexWriter lock";
    private static final String readersNotProperlyClosedInReaderProvider = "HSEARCH000054: ReaderProvider contains readers not properly closed at destroy time";
    private static final String unableToCloseLuceneIndexReader = "HSEARCH000055: Unable to close Lucene IndexReader";
    private static final String unableToUnregisterExistingMBean = "HSEARCH000056: Unable to un-register existing MBean: %1$s";
    private static final String exceptionOccurred = "HSEARCH000058: %1$s";
    private static final String workerException = "HSEARCH000059: Worker raises an exception on close()";
    private static final String interruptedBatchIndexing = "HSEARCH000062: Batch indexing was interrupted";
    private static final String errorRollingBackTransaction = "HSEARCH000065: Error while rolling back transaction after %1$s";
    private static final String failedSlaveDirectoryProviderInitialization = "HSEARCH000066: Failed to initialize SlaveDirectoryProvider %1$s";
    private static final String unableToCloseLuceneDirectory = "HSEARCH000067: Unable to properly close Lucene directory %1$s";
    private static final String unableToRetrieveObjectFromMessage = "HSEARCH000068: Unable to retrieve object from message: %1$s";
    private static final String cannotOpenIndexWriterCausePreviousError = "HSEARCH000072: Couldn't open the IndexWriter because of previous error: operation skipped, index ouf of sync!";
    private static final String backendError = "HSEARCH000073: Error in backend";
    private static final String recommendConfiguringLuceneVersion = "HSEARCH000075: Configuration setting hibernate.search.lucene_version was not specified: using LUCENE_CURRENT.";
    private static final String cantOpenCorruptedIndex = "HSEARCH000076: Could not open Lucene index: index data is corrupted. index name: '%1$s'";
    private static final String ioExceptionOnIndex = "HSEARCH000077: An IOException happened while accessing the Lucene index '%1$s'";
    private static final String unableToShutdownAsynchronousIndexingByTimeout = "HSEARCH000078: Timed out waiting to flush all operations to the backend of index %1$s";
    private static final String warnSuspiciousBackendDirectoryCombination = "HSEARCH000081: The index '%1$s' is using a non-recommended combination of backend and directoryProvider implementations";
    private static final String unableToSerializeLuceneWorks = "HSEARCH000083: Unable to serialize List<LuceneWork>";
    private static final String unableToReadSerializedLuceneWorks = "HSEARCH000084: Unable to read serialized List<LuceneWork>";
    private static final String attributeNotRecognizedNorSerializable = "HSEARCH000085: Attribute type is not recognized and not serializable: %1$s";
    private static final String unknownAttributeSerializedRepresentation = "HSEARCH000086: Unknown attribute serialized representation: %1$s";
    private static final String unableToReadTokenStream = "HSEARCH000087: Unable to read TokenStream";
    private static final String unableToConvertSerializableStoreToLuceneStore = "HSEARCH000090: Unable to convert serializable Store to Lucene Store: %1$s";
    private static final String unknownNumericFieldType = "HSEARCH000091: Unknown NumericField type: %1$s";
    private static final String conversionFromReaderToStringNotYetImplemented = "HSEARCH000092: Conversion from Reader to String not yet implemented";
    private static final String unknownFieldType = "HSEARCH000093: Unknown Field type: %1$s";
    private static final String cannotSerializeCustomField = "HSEARCH000094: Cannot serialize custom Fieldable '%1$s'. Must be NumericField, Field or a Serializable Fieldable implementation.";
    private static final String failToSerializeObject = "HSEARCH000095: Fail to serialize object of type %1$s";
    private static final String failToDeserializeObject = "HSEARCH000096: Fail to deserialize object";
    private static final String unableToDeserializeAvroStream = "HSEARCH000099: Unable to deserialize Avro stream";
    private static final String cannotDeserializeOperation = "HSEARCH000100: Cannot deserialize operation %1$s, unknown operation.";
    private static final String cannotDeserializeField = "HSEARCH000101: Cannot deserialize field type %1$s, unknown field type.";
    private static final String unableToSerializeInAvro = "HSEARCH000102: Unable to serialize Lucene works in Avro";
    private static final String unableToInitializeIndexManager = "HSEARCH000103: Unable to initialize IndexManager named '%1$s'";
    private static final String ignoringBackendOptionForIndex = "HSEARCH000104: Ignoring backend option for index '%1$s', configured IndexManager requires using '%2$s' instead.";
    private static final String cannotGetResultSizeWithCriteriaAndRestriction = "HSEARCH000105: Cannot safely compute getResultSize() when a Criteria with restriction is used. Use query.list().size() or query.getResultList().size(). Criteria at stake: %1$s";
    private static final String fieldLooksBinaryButDecompressionFailed = "HSEARCH000106: Field %1$s looks like binary but couldn't be decompressed";
    private static final String requestedIndexNotDefined = "HSEARCH000107: Index names %1$s is not defined";
    private static final String shuttingDownBackend = "HSEARCH000108: Shutting down backend for IndexManager '%1$s'";
    private static final String notAnIndexedType = "HSEARCH000109: %1$s is not an indexed type";
    private static final String nullIsInvalidIndexedType = "HSEARCH000110: 'null' is not a valid indexed type";
    private static final String needAtLeastOneIndexName = "HSEARCH000111: At least one index name must be provided: can't open an IndexReader on nothing";
    private static final String needAtLeastOneIndexedEntityType = "HSEARCH000112: At least one entity type must be provided: can't open an IndexReader on nothing";
    private static final String nullIsInvalidIndexName = "HSEARCH000113: 'null' is not a valid index name";
    private static final String unknownFullTextFilter = "HSEARCH000115: Unknown @FullTextFilter: '%1$s'";
    private static final String massIndexerUnexpectedErrorMessage = "HSEARCH000116: Unexpected error during MassIndexer operation";
    private static final String ioExceptionOnIndexWriter = "HSEARCH000117: IOException on the IndexWriter";
    private static final String exceptionDuringIndexMergeOperation = "HSEARCH000118: Exception during index Merge operation";
    private static final String optimizationSkippedStillBusy = "HSEARCH000119: Skipping optimization on index %1$s as it is already being optimized";
    private static final String inconsistentFieldConfiguration = "HSEARCH000120: There are multiple properties indexed against the same field name '%1$s.%2$s', but with different indexing settings. The behaviour is undefined.";
    private static final String forceSkipIndexOperationViaInterception = "HSEARCH000125: Interceptor enforces skip index operation %2$s on instance of class %1$s";
    private static final String forceRemoveOnIndexOperationViaInterception = "HSEARCH000126: Interceptor enforces removal of index data instead of index operation %2$s on instance of class %1$s";
    private static final String forceUpdateOnIndexOperationViaInterception = "HSEARCH000128: Interceptor enforces update of index data instead of index operation %2$s on instance of class %1$s";
    private static final String targetedFieldNotSpatial = "HSEARCH000131: The field '%1$s#%2$s' used for the spatial query is not configured as spatial field. Check the proper use of @Spatial respectively SpatialFieldBridge";
    private static final String noFieldBridgeInterfaceImplementedByClassBridge = "HSEARCH000133: @ClassBridge implementation '%1$s' should implement either org.hibernate.search.bridge.FieldBridge, org.hibernate.search.bridge.TwoWayStringBridge or org.hibernate.search.bridge.StringBridge";
    private static final String cannotInstantiateClassBridgeOfType = "HSEARCH000134: Unable to instantiate ClassBridge of type %1$s defined on %2$s";
    private static final String unableToGuessFieldBridge = "HSEARCH000135: Unable to guess FieldBridge for %2$s in %1$s";
    private static final String unableToInstantiateSpatial = "HSEARCH000136: Unable to instantiate Spatial defined on %1$s";
    private static final String noImplementationClassInFieldBridge = "HSEARCH000137: @FieldBridge with no implementation class defined in: %1$s";
    private static final String noFieldBridgeInterfaceImplementedByFieldBridge = "HSEARCH000138: @FieldBridge implementation implements none of the field bridge interfaces: %1$s in %2$s";
    private static final String unableToInstantiateFieldBridge = "HSEARCH000139: Unable to instantiate FieldBridge for %1$s of class %2$s";
    private static final String fieldBridgeNotAnInstanceof = "HSEARCH000144: FieldBridge passed in is not an instance of %1$s";
    private static final String queryWithNoTermsAfterAnalysis = "HSEARCH000146: The query string '%2$s' applied on field '%1$s' has no meaningful tokens to be matched. Validate the query input against the Analyzer applied on this field.";
    private static final String unableToDetermineClassBridge = "HSEARCH000149: Unable to determine a ClassBridge configured on type %1$s";
    private static final String unableToGetInputStreamFromBlob = "HSEARCH000150: Unable to get input stream from blob data";
    private static final String unsupportedTikaBridgeType = "HSEARCH000151: Unable to get input stream from object of type %1$s";
    private static final String fileDoesNotExist = "HSEARCH000152: File %1$s does not exist";
    private static final String fileIsADirectory = "HSEARCH000153: %1$s is a directory and not a file";
    private static final String fileIsNotReadable = "HSEARCH000154: File %1$s is not readable";
    private static final String unableToConfigureTikaBridge = "HSEARCH000155: Unable to configure %1$s";
    private static final String cannotReadFieldForClass = "HSEARCH000156: Cannot read %1$s field from a %2$s object: does getter exist and is it public ?";
    private static final String cannotExtractCoordinateFromObject = "HSEARCH000157: Class %1$s does not implement the Coordinates interface";
    private static final String cannotHaveTwoSpatialsWithDefaultOrSameName = "HSEARCH000158: Class %1$s cannot have two @Spatial using default/same name";
    private static final String cannotFindCoordinatesNorLatLongForSpatial = "HSEARCH000159: Cannot find a Coordinates interface nor @Latitude/@Longitude annotations bound to the @Spatial name '%1$s' for class %2$s. It might be a typo (or a lapse) in @Latitude.of / @Longitude.of attributes.";
    private static final String ambiguousLatitudeDefinition = "HSEARCH000160: @Latitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private static final String ambiguousLongitudeDefinition = "HSEARCH000161: @Longitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private static final String unableToOpenJMSConnection = "HSEARCH000162: Unable to open JMS connection on queue '%2$s' for index '%1$s'";
    private static final String unableToSendJMSWork = "HSEARCH000163: Unable to send Search work to JMS queue '%2$s' for index '%1$s'";
    private static final String jmsQueueLookupException = "HSEARCH000164: Unable to lookup Search queue '%1$s' for index '%2$s'";
    private static final String indexManagerAliasResolved = "HSEARCH000166: IndexManager factory resolved alias '%1$s' to '%2$s'.";
    private static final String duplicateDocumentIdFound = "HSEARCH000167: More than one @DocumentId specified on entity '%1$s'";
    private static final String indexManagerUsesSerializationService = "HSEARCH000168: Serialization service %2$s being used for index '%1$s'";
    private static final String fieldBridgeNotTwoWay = "HSEARCH000169: FieldBridge '%1$s' does not have a objectToString method: field '%2$s' in '%3$s' The FieldBridge must be a TwoWayFieldBridge or you have to enable the ignoreFieldBridge option when defining a Query";
    private static final String unableToParseDocument = "HSEARCH000176: Document could not be parsed";
    private static final String noDocumentIdFoundException = "HSEARCH000177: Unable to find a valid document id for entity '%1$s'";
    private static final String getNullSessionPassedToFullTextSessionCreationException = "HSEARCH000178: Unable to create a FullTextSession from a null Session";
    private static final String getNullEntityManagerPassedToFullEntityManagerCreationException = "HSEARCH000179: Unable to create a FullTextEntityManager from a null EntityManager";
    private static final String getUnableToNarrowFieldDescriptorException = "HSEARCH000180: Unable to cast %s of type %s to %s";
    private static final String getPropertyNameCannotBeNullException = "HSEARCH000181: 'null' is not a valid property name";
    private static final String getFieldNameCannotBeNullException = "HSEARCH000182: 'null' is not a valid field name";
    private static final String massIndexerUnableToIndexInstance = "HSEARCH000183: Unable to index instance of type %s while batch indexing: %s";
    private static final String entityWithNoShard = "HSEARCH000184: Cannot define an entity with 0 shard on '%1$s'";
    private static final String assertionFailureCannotCastToWorkerBuilderContext = "HSEARCH000186: [AssertionFailure: open a bug report] SearchFactory from entityIndexBinding is not assignable to WorkerBuilderContext. Actual class is %1$s";
    private static final String getNoSessionFactoryInContextException = "HSEARCH000190: Unable to start HibernateSessionFactoryServiceProvider. There is no session factory in the context. Are you sure you have Hibernate ORM enabled?";
    private static final String getInvalidShardCountException = "HSEARCH000191: The number of shards must be >= 1. %s is an illegal value.";
    private static final String getInvalidIntegerValueException = "HSEARCH000192: %s";
    private static final String idHashShardingWithSingleShard = "HSEARCH000193: Selected sharding strategy is IdHashShardingStrategy. However, there is only 1 shard configured. Have you set the 'nbr_of_shards' property?";
    private static final String getUnableToLoadShardingStrategyClassException = "HSEARCH000194: Unable to load configured class '%s' as 'sharding_strategy'";
    private static final String getMultipleServiceImplementationsException = "HSEARCH000195: Multiple service implementations detected for service '%1$s': '%2$s'";
    private static final String getNoServiceImplementationFoundException = "HSEARCH000196: No service implementations for service '%1$s' can be found";
    private static final String getUnableToCreateJGroupsBackendException = "HSEARCH000197: Unable to create JGroups backend. Are you sure you have the JGroups dependencies on the classpath?";
    private static final String getUnexpectedServiceStatusException = "HSEARCH000198: Unexpected status '%s' for service '%s'. Check for circular dependencies or unreleased resources in your services.";
    private static final String configurationPropertyCantBeEmpty = "HSEARCH000199: Configuration property '%s' should not be empty: illegal format.";
    private static final String incorrectEditDistance = "HSEARCH000201: The edit distance must be either 1 or 2";
    private static final String entityWithIdNotFound = "HSEARCH000202: Unable to find entity $1%s with id $2%s";
    private static final String noFieldCompatibleForMoreLikeThis = "HSEARCH000203: No field from %s can be used for More Like This queries. They are neither stored or including the term vectors.";
    private static final String ioExceptionOnIndexOfEntity = "HSEARCH000205: An IOException happened while accessing the Lucene indexes related to '%1$s'";
    private static final String requireTFIDFSimilarity = "HSEARCH000206: MoreLikeThis queries require a TFIDFSimilarity for entity '$1%s'";
    private static final String fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis = "HSEARCH000207: Field %s of entity %s cannot be used in a MoreLikeThis query: the term vector (preferred) or the value itself need to be stored.";
    private static final String classLoaderServiceContainedInProvidedServicesException = "HSEARCH000208: ClassLoaderService cannot be provided via SearchConfiguration#getProvidedServices. Use SearchConfiguration#getClassLoaderService!";
    private static final String serviceRequestedAfterReleasedAllWasCalled = "HSEARCH000209: It is not allowed to request further services after ServiceManager#releaseAll has been called.";
    private static final String providedServicesCannotImplementStartableOrStoppable = "HSEARCH000210: Provided service '%s' implements '%s'. Provided services are not allowed to implement either Startable or Stoppable.";
    private static final String massIndexerExceptionWhileFetchingIds = "HSEARCH000211: An exception occurred while the MassIndexer was fetching the primary identifiers list";
    private static final String massIndexerExceptionWhileTransformingIds = "HSEARCH000212: An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents";
    private static final String fieldIdCannotBeUsedInMoreLikeThis = "HSEARCH000213: Field %s of entity %s cannot be used in a MoreLikeThis query. Ids and embedded ids are excluded.";
    private static final String numericFieldCannotBeUsedInMoreLikeThis = "HSEARCH000214: Field %s of entity %s cannot be used in a MoreLikeThis query. Numeric fields are not considered for the moment.";
    private static final String multipleMatchingFieldBridges = "HSEARCH000215: Multiple matching FieldBridges found for %s of return type %s: %s";
    private static final String invalidIncludePathConfiguration = "HSEARCH000216: Found invalid @IndexedEmbedded->paths elements configured for member '%s' of class '%s'. The invalid paths are [%s]";
    private static final String invalidPropertyValue = "HSEARCH000217: Invalid value '%s' for setting '%s'. Check the documentation for allowed values.";
    private static final String unknownFieldNameForMoreLikeThisQuery = "HSEARCH000218: More like this query cannot be created, because the index does not contain a field '%s' for the type '%s";
    private static final String jmsInitialContextException = "HSEARCH000219: Could not lookup initial JNDI context for the JMS ConnectionFactory named '%s' for the index '%s";
    private static final String jmsQueueFactoryLookupException = "HSEARCH000220: Could not lookup JMS ConnectionFactory named '%1s' for the index '%2s";
    private static final String detectInfiniteTypeLoopInIndexedEmbedded = "HSEARCH000221: Circular reference. Entity %1s was already encountered, and was encountered again in entity %2s at path '%3s'. Set the @IndexedEmbedded.depth value explicitly to fix the problem.";
    private static final String searchIntegratorNotInitialized = "HSEARCH000222: The SearchFactory was not initialized";
    private static final String searchFactoryReferenceServiceNotFound = "HSEARCH000223: The Service org.hibernate.search.hcore.impl.SearchFactoryReference was not found in the Hibernate ORM Service Registry. This might be caused by the Hibernate ORM classloader not having visibility on Hibernate Search";
    private static final String parametersShouldNotBeNull = "HSEARCH000224: Non optional parameter named '%s' was null";
    private static final String lockingFailureDuringInitialization = "HSEARCH000225: An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.";
    private static final String logInfoStreamMessage = "HSEARCH000226: %s: %s";
    private static final String booleanQueryWithoutClauses = "HSEARCH000227: A BooleanQuery is not valid without at least one clause. Use at least one of should(Query) or must(Query).";
    private static final String illegalLuceneVersionFormat = "HSEARCH000228: Property hibernate.search.lucene_version set to value '%s' is not in a valid format to express a Lucene version: %s";
    private static final String flushIntervalNeedsToBePositive = "HSEARCH000229: Property index_flush_intervalfor the index '%s' needs to be positive.";
    private static final String startingSyncConsumerThread = "HSEARCH000230: Starting sync consumer thread for index '%s'";
    private static final String stoppingSyncConsumerThread = "HSEARCH000231: Stopping sync consumer thread for index '%s'";
    private static final String stringEncodedFieldsAreTargetedWithNumericQuery = "HSEARCH000232: The specified query '%s' contains a numeric sub query which targets the string encoded field(s) '%s'. Check your query or try limiting the targeted entities.";
    private static final String numericEncodedFieldsAreTargetedWithStringQuery = "HSEARCH000233: The specified query '%s' contains a string based sub query which targets the numeric encoded field(s) '%s'. Check your query or try limiting the targeted entities.";
    private static final String targetedEntityTypesNotIndexed = "HSEARCH000234: None of the specified entity types ('%s') or any of their subclasses are indexed.";
    private static final String luceneBackendInitializedSynchronously = "HSEARCH000235: Backend for index '%s' started: using a Synchronous batching backend.";
    private static final String luceneBackendInitializedAsynchronously = "HSEARCH000236: Backend for index '%s' started: using an Asynchronous backend with periodic commits.";
    private static final String rangeQueryWithNullToAndFromValue = "HSEARCH000237: Cannot create numeric range query for field '%s', since from and to values are null";
    private static final String numericRangeQueryWithNonNumericToAndFromValues = "HSEARCH000238: Cannot create numeric range query for field '%s', since values are not numeric (Date, int, long, short or double)";
    private static final String unknownEncodingType = "HSEARCH000239: Unknown field encoding type: %1$s";
    private static final String invalidStringDateFieldInDocument = "HSEARCH000240: Unable to parse value '%2$s' of field '%1$s' into a Date";
    private static final String multipleFactoryMethodsInClass = "HSEARCH000241: Multiple @Factory methods defined in %s";
    private static final String noPublicNoArgConstructor = "HSEARCH000242: Hibernate Search failed to initialize component '%1$s' as class '%2$s' doesn't have a public no-arguments constructor";
    private static final String factoryMethodsMustReturnAnObject = "HSEARCH000244: Factory methods must return an object. '%1$s#%2$s' does not";
    private static final String unableToAccessMethod = "HSEARCH000245: Unable to access method '%1$s#%2$s'";
    private static final String exceptionDuringFactoryMethodExecution = "HSEARCH000246: An exception occurred while invoking '%1$s#%2$s'";
    private static final String fieldTriesToOverrideIdFieldSettings = "HSEARCH000247: An indexed field defined on '%1$s:%2$s' tries to override the id field settings. The document id field settings cannot be modified. Use a different field name.";
    private static final String workListShouldNeverBeEmpty = "HSEARCH000248: WorkList should never be empty. Stacktrace below \n %s";
    private static final String singleTermDeleteDisabled = "HSEARCH000249: Cannot do fast deletes on index '%s'. Entities in this index are conflicting or the index can accept unknown entities.";
    private static final String unsupportedErrorHandlerConfigurationValueType = "HSEARCH000250: Unsupported value type for configuration property hibernate.search.error_handler: %1$s";
    private static final String unableToSetFilterParameter = "HSEARCH000251: Unable to set filter parameter '%2$s' on filter class %1$s";
    private static final String cannotInitializeDirectoryProvider = "HSEARCH000252: Unable to initialize directory provider %1$s for index %2$s";
    private static final String indexBasePathRequiredForLockingStrategy = "HSEARCH000253: To use '%1$s' as a locking strategy, an indexBase path must be set";
    private static final String unknownIndexingMode = "HSEARCH000254: Unknown indexing mode: %1$s";
    private static final String unknownDocValuesTypeType = "HSEARCH000255: Unknown DocValues type: %1$s";
    private static final String unexpectedBinaryDocValuesTypeType = "HSEARCH000256: '%1$s' is an unexpected type for a binary doc value";
    private static final String unexpectedNumericDocValuesTypeType = "HSEARCH000257: '%1$s' is an unexpected type for a numeric doc value";
    private static final String loadingNonExistentField = "HSEARCH000258: Attempting to load a field named '%s' from the Lucene Document. This Document instance doesn't have such a field.";
    private static final String unableToDeleteByQuery = "HSEARCH000259: Unable to delete all %s matching Query: %s";
    private static final String givenCriteriaObjectCannotBeApplied = "HSEARCH000260: A criteria for loading query results has been specified via FullTextQuery#setCriteriaQuery(), but query results originate from several id spaces. The given criteria object can therefore not be be applied.";
    private static final String unknownDeletionQueryKeySpecified = "HSEARCH000261: An unknown DeletionQuery key was specified during de-serialization of a message from another node: %d";
    private static final String numericFieldAnnotationWithoutMatchingField = "HSEARCH000262: @NumericField annotation is used on %1$s#%2$s without a matching @Field annotation";
    private static final String facetAnnotationWithoutMatchingField = "HSEARCH000263: @Facet annotation is used on %1$s#%2$s without a matching @Field annotation";
    private static final String unsupportedFieldTypeForFaceting = "HSEARCH000264: @Facet is not supported for type '%1$s'. See %2$s#%3$s";
    private static final String errorDuringFacetingIndexing = "HSEARCH000265: Unable to build Lucene Document due to facet indexing error";
    private static final String numericDateFacetForNonNumericField = "HSEARCH000267: Unable to index date facet '%1$s' for field '%2$s', since the matching field is not using a numeric field bridge";
    private static final String unknownFieldNameForFaceting = "HSEARCH000268: Facet request '%1$s' tries to facet on  field '%2$s' which either does not exist or is not configured for faceting (via @Facet). Check your configuration.";
    private static final String unsupportedParameterTypeForRangeFaceting = "HSEARCH000269: '%1$s' is not a supported type for a range faceting request parameter. Supported types are: '%2$s'";
    private static final String noStartOrEndSpecifiedForRangeQuery = "HSEARCH000270: At least of of the facets ranges in facet request '%1$s' contains neither start nor end value";
    private static final String rangeDefinitionOrderRequestedForDiscreteFacetRequest = "HSEARCH000271: RANGE_DEFINITION_ORDER is not a valid sort order for a discrete faceting request.";
    private static final String attemptToCreateFacetingRequestForUnindexedEntity = "HSEARCH000272: Entity '%1$s' is not an indexed entity. Unable to create faceting request";
    private static final String attemptToFacetOnAnalyzedField = "HSEARCH000273: The indexed field '%1$s' in '%2$s' is analyzed and marked for faceting. Only un-analyzed fields can be faceted.";
    private static final String executingLuceneQuery = "HSEARCH000274: Executing Lucene query '%s'";
    private static final String serializationProviderNotFoundException = "HSEARCH000275: SerializationProvider service not found on the classpath. You should check that an implementation exists and it's correctly registered as a service. If that's not the case, you can also create a custom implementation or add \"org.hibernate:hibernate-search-serialization-avro\" on the classpath";
    private static final String transactionNotActiveWhileProducingIdsForBatchIndexing = "HSEARCH000276: No transaction is active while indexing entity type '%1$s'; Consider increasing the connection time-out";
    private static final String backendNonTransactional = "HSEARCH000277: Worker configured to be enlisted in transaction but the backend %1$s is not transactional for index %2$s";
    private static final String cantQueryUnindexedType = "HSEARCH000278: Can't build query for type '%1$s' which is neither indexed nor has any indexed sub-types.";
    private static final String assertionNotLoadingUTF8Charset = "HSEARCH000279: Unable to load the UTF-8 Charset!";
    private static final String sourceDirectoryNotExisting = "HSEARCH000280: Source directory does not exist: '%1$s";
    private static final String directoryIsNotReadable = "HSEARCH000281: Unable to read directory: '%1$s";
    private static final String distanceSortRequiresSpatialField = "HSEARCH000282: Distance sort can only be used with spatial fields: '%1$s' is not spatial";
    private static final String sortRequiresIndexedField = "HSEARCH000283: Sorting using '%1$s' requires an indexed field: '%2$s' is not valid";
    private static final String ioExceptionOnMultiReaderRefresh = "HSEARCH000284: An IOException happened while opening multiple indexes";
    private static final String couldNotCreateUninvertingReader = "HSEARCH000285: Could not create uninverting reader for reader %s";
    private static final String readerTypeUnsupportedForInverting = "HSEARCH000286: Could not create uninverting reader for reader of type %s; Only directory readers are supported";
    private static final String sortFieldTypeUnsupported = "HSEARCH000287: Unsupported sort type for field %1$s: %2$s";
    private static final String deprecatedConfigurationPropertyIsIgnored = "HSEARCH000288: The configuration property '%s' no longer applies and will be ignored.";
    private static final String uncoveredSortsRequested = "HSEARCH000289: Requested sort field(s) %3$s are not configured for entity type %1$s mapped to index %2$s, thus an uninverting reader must be created. You should declare the missing sort fields using @SortableField.";
    private static final String invalidNullMarkerForDouble = "HSEARCH000290: The 'indexNullAs' property for fields indexed as Doubles must represent a Double number.";
    private static final String invalidNullMarkerForFloat = "HSEARCH000291: The 'indexNullAs' property for fields indexed as Floats must represent a Float number.";
    private static final String invalidNullMarkerForInteger = "HSEARCH000292: The 'indexNullAs' property for fields indexed as Integer must represent an Integer number.";
    private static final String invalidNullMarkerForLong = "HSEARCH000293: The 'indexNullAs' property for fields indexed as Longs must represent a Long number.";
    private static final String unableToSearchOnNullValueWithoutFieldBridge = "HSEARCH000294: Unable to search for null token on field '%1$s' if field bridge is ignored.";
    private static final String parseException = "HSEARCH000295: String '$1%s' cannot be parsed into a '$2%s'";
    private static final String valueTooLargeForConversionException = "HSEARCH000297:  Value of '%2$s' for type '%1$s' is too big for the conversion";
    private static final String inconsistentSortableFieldConfigurationForSharedIndex = "HSEARCH000298: Inconsisent configuration of sort fields %2$s for index '%1$s'. Make sure they are configured using @SortableField for all entities mapped to this index.";
    private static final String sortableFieldRefersToUndefinedField = "HSEARCH000299: @SortableField declared on %s#%s references to undeclared field '%s'";
    private static final String severalNumericFieldAnnotationsForSameField = "HSEARCH000300: Several @NumericField annotations used on %1$s#%2$s refer to the same field";
    private static final String uncoveredSortsRequestedWithUninvertingNotAllowed = "HSEARCH000301: Requested sort field(s) %3$s are not configured for entity type %1$s mapped to index %2$s, thus an uninverting reader must be created. You should declare the missing sort fields using @SortableField.";
    private static final String cannotRunLuceneQueryTargetingEntityIndexedWithNonLuceneIndexManager = "HSEARCH000302: Cannot execute query '%2$s', as targeted entity type '%1$s' is not mapped to an embedded Lucene index.";
    private static final String timedOutWaitingShutdown = "HSEARCH000303: Timeout while waiting for indexing resources to properly flush and close on shut down ofindexing backend for index '%s'. Some pending index writes might have been lost.";
    private static final String closingIndexWriter = "HSEARCH000304: Closing index writer for IndexManager '%1$s'";
    private static final String analyzerReferenceNotInitialized = "HSEARCH000305: Analyzer reference with name '%2$s' not initialized for field '%1$s'";
    private static final String indexManagerTypeRequiredToBuildFieldBridge = "HSEARCH000306: Index manager type is required to build a field bridge for %2$s in %1$s";
    private static final String sortTypeDoesNotMatchFieldType = "HSEARCH000307: Sort type %1$s is not compatible with %2$s type of field '%3$s'.";
    private static final String analyzerReferenceIsNotRemote = "HSEARCH000308: Analyzer reference %1$s is not a remote analyzer reference.";
    private static final String analyzerReferenceIsNotLucene = "HSEARCH000309: Analyzer reference %1$s is not a Lucene analyzer reference.";
    private static final String lazyLuceneAnalyzerReferenceNotInitialized = "HSEARCH000312: Lazy Lucene analyzer reference %1$s is not initialized.";
    private static final String remoteAnalyzerNotInitialized = "HSEARCH000313: Remote analyzer reference %1$s is not initialized.";
    private static final String lazyRemoteAnalyzerReferenceNotInitialized = "HSEARCH000315: Lazy remote analyzer reference %1$s is not initialized.";
    private static final String unexpectedProjectionConstant = "HSEARCH000317: Projection constant '%s' is not supported for this query.";
    private static final String deprecatedBackendName = "HSEARCH000318: The backend name 'lucene' is deprecated. Use 'local' instead";
    private static final String usingSerializationService = "HSEARCH000319: Using serialization service %1$s";
    private static final String couldNotAnalyzeSortableField = "HSEARCH000320: Could not analyze sortable field '%1$s'.";
    private static final String multipleTermsInAnalyzedSortableField = "HSEARCH000321: The analysis of field '%1$s' produced multiple tokens. Tokenization or term generation (synonyms) should not be used on sortable fields. Only the first token will be indexed.";
    private static final String timedOutWaitingShutdownOfReaderProvider = "HSEARCH000322: Timeout while waiting for background index reader resources to shut downgracefully for index '%s'.";
    private static final String projectingNonStoredField = "HSEARCH000323: The field '%1$s' is not stored.";
    private static final String nullMarkerInvalidFormat = "HSEARCH000325: The 'indexNullAs' property for field '%2$s', with value '%1$s', has invalid format: %3$s Could not parse '%1$s'.";
    private static final String indexNamesCollisionDetected = "HSEARCH000326: Index names collision detected. Different index managers will point to the same actual index: %1$s";
    private static final String cannotCreateBridgeDefinedField = "HSEARCH000328: Cannot create context for class: %1$s";
    private static final String analyzerDefinitionNamingConflict = "HSEARCH000330: Multiple analyzer definitions with the same name: '%1$s'.";
    private static final String cantQueryUnconfiguredType = "HSEARCH000331: Can't build query for type '%1$s' which is neither configured nor has any configured sub-types.";
    private static final String targetedEntityTypesNotConfigured = "HSEARCH000332: None of the specified entity types ('%s') or any of their subclasses are configured.";
    private static final String queryWithNoIndexedType = "HSEARCH000333: Cannot query: there aren't any mapped entity. Don't forget to add @Indexed to at least one class.";
    private static final String simpleQueryParserDoesNotSupportNullQueries = "HSEARCH000334: The simple query parser does not support null queries.";
    private static final String fileDeleteFailureIgnored = "HSEARCH000336: A file could not be deleted: likely lock contention. Not a problem for index replications as it will be attempted again in the future.";
    private static final String conflictingParameterDefined = "HSEARCH000337: Conflicting usage of @Parameter annotation for parameter name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    private static final String incompleteEntityInfo = "HSEARCH000338: Incomplete entity information in a document retrieved from the index: the entity type ('%1$s') or identifier ('%2$s') was missing.";
    private static final String beanResolverContainedInProvidedServicesException = "HSEARCH000339: BeanResolver cannot be provided via SearchConfiguration#getProvidedServices. Use SearchConfiguration#getBeanResolver!";
    private static final String fullTextFilterDefinitionNamingConflict = "HSEARCH000340: Multiple full-text filter definitions with the same name: '%1$s'.";
    private static final String normalizerDefinitionNamingConflict = "HSEARCH000341: Multiple normalizer definitions with the same name: '%1$s'.";
    private static final String cannotReferenceAnalyzerAndNormalizer = "HSEARCH000342: Field '%2$s' on entity '%1$s' refers to both an analyzer and a normalizer.";
    private static final String invalidEmptyNormalizerDefinition = "HSEARCH000343: Normalizer definition for '%s' must define at least a char filter or a token filter (or both).";
    private static final String normalizerProducedMultipleTokens = "HSEARCH000344: The normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    private static final String sortableFieldWithNonNormalizerAnalyzer = "HSEARCH000345: Field '%2$s' on entity '%1$s' is marked as sortable and will be analyzed, but is assigned an Analyzer instead of a Normalizer. Sortable fields should be assigned normalizers in order to avoid problems with tokenization.";
    private static final String usingDeprecatedNameForRamDirectoryProvider = "HSEARCH000346: The 'ram' directory provider is deprecated and will be removed in a future version. You should use 'local-heap' instead. Also, this should not be used in a production environment. Please refer to the official documentation for more information.";
    private static final String incompatibleEntityManagerFactory = "HSEARCH000347: The EntityManagerFactory of type '%s' is not an Hibernate based EntityManagerFactory, or not compatible with this version of Hibernate Search.";
    private static final String someTargetedEntityTypesNotConfigured = "HSEARCH000348: Some of the specified entity types ('%s') are not configured, nor is any of their subclasses.";
    private static final String someTargetedEntityTypesNotIndexed = "HSEARCH000349: Some of the specified entity types ('%s') are not indexed, nor is any of their subclasses.";
    private static final String mustBePositiveOrZero = "HSEARCH000350: '%1$s' must be positive or zero.";
    private static final String minimumShouldMatchMinimumOutOfBounds = "HSEARCH000351: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    private static final String minimumShouldMatchConflictingConstraints = "HSEARCH000352: Multiple conflicting minimumShouldMatch constraints";
    private static final String unknownAnalyzerForOverride = "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    private static final String invalidConversionFromLuceneAnalyzer = "HSEARCH000354: This analyzer is defined as an embedded Lucene analyzer, and cannot be used with any other technology (Elasticsearch in particular). Analyzer reference: %s";
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String illegalObjectRetrievedFromMessage = "HSEARCH000069: Illegal object retrieved from message";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String unknownResolution = "HSEARCH000140: Unknown Resolution: %1$s";
    private static final String unsupportedFacetRangeParameter = "HSEARCH000266: '%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported";
    private static final String projectingFieldWithoutTwoWayFieldBridge = "HSEARCH000324: The fieldBridge for field '%1$s' is an instance of '%2$s', which does not implement TwoWayFieldBridge. Projected fields must have a TwoWayFieldBridge.";
    private static final String unsupportedNullTokenType = "HSEARCH000327: Unsupported indexNullAs token type '%3$s' on field '%2$s' of entity '%1$s'.";
    private static final String invalidLuceneAnalyzerDefinitionProvider = "HSEARCH000329: Property 'hibernate.search.lucene.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement LuceneAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a LuceneAnalyzerDefinitionProvider.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void initializedBlackholeBackend() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.initializedBlackholeBackend$str(), new Object[0]);
    }

    protected String initializedBlackholeBackend$str() {
        return initializedBlackholeBackend;
    }

    @Override
    public final void closedBlackholeBackend() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.closedBlackholeBackend$str(), new Object[0]);
    }

    protected String closedBlackholeBackend$str() {
        return closedBlackholeBackend;
    }

    @Override
    public final void incorrectMessageType(Class<?> messageType) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.incorrectMessageType$str(), (Object)new ClassFormatter(messageType));
    }

    protected String incorrectMessageType$str() {
        return incorrectMessageType;
    }

    @Override
    public final void interruptedWorkError(Runnable r) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedWorkError$str(), (Object)r);
    }

    protected String interruptedWorkError$str() {
        return interruptedWorkError;
    }

    @Override
    public final void skippingDirectorySynchronization(String indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.skippingDirectorySynchronization$str(), (Object)indexName);
    }

    protected String skippingDirectorySynchronization$str() {
        return skippingDirectorySynchronization;
    }

    @Override
    public final void unableToRemovePreviousMarker(String indexName, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToRemovePreviousMarker$str(), (Object)indexName);
    }

    protected String unableToRemovePreviousMarker$str() {
        return unableToRemovePreviousMarker;
    }

    @Override
    public final void unableToCreateCurrentMarker(String indexName, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCreateCurrentMarker$str(), (Object)indexName);
    }

    protected String unableToCreateCurrentMarker$str() {
        return unableToCreateCurrentMarker;
    }

    @Override
    public final void unableToSynchronizeSource(String indexName, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToSynchronizeSource$str(), (Object)indexName);
    }

    protected String unableToSynchronizeSource$str() {
        return unableToSynchronizeSource;
    }

    @Override
    public final void unableToDetermineCurrentInSourceDirectory() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToDetermineCurrentInSourceDirectory$str(), new Object[0]);
    }

    protected String unableToDetermineCurrentInSourceDirectory$str() {
        return unableToDetermineCurrentInSourceDirectory;
    }

    @Override
    public final void unableToCompareSourceWithDestinationDirectory(String source, String destination) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unableToCompareSourceWithDestinationDirectory$str(), (Object)source, (Object)destination);
    }

    protected String unableToCompareSourceWithDestinationDirectory$str() {
        return unableToCompareSourceWithDestinationDirectory;
    }

    @Override
    public final void idCannotBeExtracted(String affectedOwnerEntityName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.idCannotBeExtracted$str(), (Object)affectedOwnerEntityName);
    }

    protected String idCannotBeExtracted$str() {
        return idCannotBeExtracted;
    }

    @Override
    public final void serviceProviderNotReleased(Class<?> class1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.serviceProviderNotReleased$str(), (Object)new ClassFormatter(class1));
    }

    protected String serviceProviderNotReleased$str() {
        return serviceProviderNotReleased;
    }

    @Override
    public final void stopServiceFailed(Class<?> class1, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.stopServiceFailed$str(), (Object)new ClassFormatter(class1));
    }

    protected String stopServiceFailed$str() {
        return stopServiceFailed;
    }

    @Override
    public final void indexingEntities(long count) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntities$str(), (Object)count);
    }

    protected String indexingEntities$str() {
        return indexingEntities;
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities);
    }

    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }

    @Override
    public final void indexingCompletedAndMBeanUnregistered(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingCompletedAndMBeanUnregistered$str(), (Object)nbrOfEntities);
    }

    protected String indexingCompletedAndMBeanUnregistered$str() {
        return indexingCompletedAndMBeanUnregistered;
    }

    @Override
    public final void indexingDocumentsCompleted(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingDocumentsCompleted$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }

    @Override
    public final void indexingSpeed(float estimateSpeed, float estimatePercentileComplete) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingSpeed$str(), (Object)Float.valueOf(estimateSpeed), (Object)Float.valueOf(estimatePercentileComplete));
    }

    protected String indexingSpeed$str() {
        return indexingSpeed;
    }

    @Override
    public final void notDeleted(File file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.notDeleted$str(), (Object)file);
    }

    protected String notDeleted$str() {
        return notDeleted;
    }

    @Override
    public final void version(String versionString) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.version$str(), (Object)versionString);
    }

    protected String version$str() {
        return version;
    }

    @Override
    public final void couldNotCloseResource(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.couldNotCloseResource$str(), new Object[0]);
    }

    protected String couldNotCloseResource$str() {
        return couldNotCloseResource;
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return cannotGuessTransactionStatus;
    }

    @Override
    public final void unableToCloseSearcherDuringQuery(String query, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseSearcherDuringQuery$str(), (Object)query);
    }

    protected String unableToCloseSearcherDuringQuery$str() {
        return unableToCloseSearcherDuringQuery;
    }

    @Override
    public final void forceToUseDocumentExtraction() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.forceToUseDocumentExtraction$str(), new Object[0]);
    }

    protected String forceToUseDocumentExtraction$str() {
        return forceToUseDocumentExtraction;
    }

    @Override
    public final void unableToCloseSearcherInScrollableResult(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseSearcherInScrollableResult$str(), new Object[0]);
    }

    protected String unableToCloseSearcherInScrollableResult$str() {
        return unableToCloseSearcherInScrollableResult;
    }

    @Override
    public final void unexpectedValueMissingFromFieldCache() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unexpectedValueMissingFromFieldCache$str(), new Object[0]);
    }

    protected String unexpectedValueMissingFromFieldCache$str() {
        return unexpectedValueMissingFromFieldCache;
    }

    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(String absolutePath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexDirectoryNotFoundCreatingNewOne$str(), (Object)absolutePath);
    }

    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return indexDirectoryNotFoundCreatingNewOne;
    }

    @Override
    public final void noCurrentMarkerInSourceDirectory() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noCurrentMarkerInSourceDirectory$str(), new Object[0]);
    }

    protected String noCurrentMarkerInSourceDirectory$str() {
        return noCurrentMarkerInSourceDirectory;
    }

    @Override
    public final void foundCurrentMarker() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.foundCurrentMarker$str(), new Object[0]);
    }

    protected String foundCurrentMarker$str() {
        return foundCurrentMarker;
    }

    @Override
    public final void abstractClassesCannotInsertDocuments(String clazz) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.abstractClassesCannotInsertDocuments$str(), (Object)clazz);
    }

    protected String abstractClassesCannotInsertDocuments$str() {
        return abstractClassesCannotInsertDocuments;
    }

    @Override
    public final void containedInPointsToProvidedId(Class<?> objectClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.containedInPointsToProvidedId$str(), (Object)new ClassFormatter(objectClass));
    }

    protected String containedInPointsToProvidedId$str() {
        return containedInPointsToProvidedId;
    }

    @Override
    public final void cannotExtractValueForIdentifier(Class<?> beanClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotExtractValueForIdentifier$str(), (Object)new ClassFormatter(beanClass));
    }

    protected String cannotExtractValueForIdentifier$str() {
        return cannotExtractValueForIdentifier;
    }

    @Override
    public final void unableToCloseJmsConnection(String jmsQueueName, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseJmsConnection$str(), (Object)jmsQueueName);
    }

    protected String unableToCloseJmsConnection$str() {
        return unableToCloseJmsConnection;
    }

    @Override
    public final void unableToRetrieveNamedAnalyzer(String value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToRetrieveNamedAnalyzer$str(), (Object)value);
    }

    protected String unableToRetrieveNamedAnalyzer$str() {
        return unableToRetrieveNamedAnalyzer;
    }

    @Override
    public final void pushedChangesOutOfTransaction() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.pushedChangesOutOfTransaction$str(), new Object[0]);
    }

    protected String pushedChangesOutOfTransaction$str() {
        return pushedChangesOutOfTransaction;
    }

    @Override
    public final void forcingReleaseIndexWriterLock() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.forcingReleaseIndexWriterLock$str(), new Object[0]);
    }

    protected String forcingReleaseIndexWriterLock$str() {
        return forcingReleaseIndexWriterLock;
    }

    @Override
    public final void readersNotProperlyClosedInReaderProvider() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.readersNotProperlyClosedInReaderProvider$str(), new Object[0]);
    }

    protected String readersNotProperlyClosedInReaderProvider$str() {
        return readersNotProperlyClosedInReaderProvider;
    }

    @Override
    public final void unableToCloseLuceneIndexReader(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseLuceneIndexReader$str(), new Object[0]);
    }

    protected String unableToCloseLuceneIndexReader$str() {
        return unableToCloseLuceneIndexReader;
    }

    @Override
    public final void unableToUnregisterExistingMBean(String name, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToUnregisterExistingMBean$str(), (Object)name);
    }

    protected String unableToUnregisterExistingMBean$str() {
        return unableToUnregisterExistingMBean;
    }

    @Override
    public final void exceptionOccurred(String errorMsg, Throwable exceptionThatOccurred) {
        this.log.logf(FQCN, Logger.Level.ERROR, exceptionThatOccurred, this.exceptionOccurred$str(), (Object)errorMsg);
    }

    protected String exceptionOccurred$str() {
        return exceptionOccurred;
    }

    @Override
    public final void workerException(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.workerException$str(), new Object[0]);
    }

    protected String workerException$str() {
        return workerException;
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    @Override
    public final void errorRollingBackTransaction(String message, Exception e1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e1, this.errorRollingBackTransaction$str(), (Object)message);
    }

    protected String errorRollingBackTransaction$str() {
        return errorRollingBackTransaction;
    }

    @Override
    public final void failedSlaveDirectoryProviderInitialization(String indexName, Exception re) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)re, this.failedSlaveDirectoryProviderInitialization$str(), (Object)indexName);
    }

    protected String failedSlaveDirectoryProviderInitialization$str() {
        return failedSlaveDirectoryProviderInitialization;
    }

    @Override
    public final void unableToCloseLuceneDirectory(Object directory, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToCloseLuceneDirectory$str(), directory);
    }

    protected String unableToCloseLuceneDirectory$str() {
        return unableToCloseLuceneDirectory;
    }

    @Override
    public final void unableToRetrieveObjectFromMessage(Class<?> messageClass, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToRetrieveObjectFromMessage$str(), (Object)new ClassFormatter(messageClass));
    }

    protected String unableToRetrieveObjectFromMessage$str() {
        return unableToRetrieveObjectFromMessage;
    }

    @Override
    public final void cannotOpenIndexWriterCausePreviousError() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotOpenIndexWriterCausePreviousError$str(), new Object[0]);
    }

    protected String cannotOpenIndexWriterCausePreviousError$str() {
        return cannotOpenIndexWriterCausePreviousError;
    }

    @Override
    public final void backendError(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.backendError$str(), new Object[0]);
    }

    protected String backendError$str() {
        return backendError;
    }

    @Override
    public final void recommendConfiguringLuceneVersion() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recommendConfiguringLuceneVersion$str(), new Object[0]);
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return recommendConfiguringLuceneVersion;
    }

    protected String cantOpenCorruptedIndex$str() {
        return cantOpenCorruptedIndex;
    }

    @Override
    public final SearchException cantOpenCorruptedIndex(CorruptIndexException e, String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cantOpenCorruptedIndex$str(), indexName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnIndex$str() {
        return ioExceptionOnIndex;
    }

    @Override
    public final SearchException ioExceptionOnIndex(IOException e, String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnIndex$str(), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unableToShutdownAsynchronousIndexingByTimeout(String indexName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unableToShutdownAsynchronousIndexingByTimeout$str(), (Object)indexName);
    }

    protected String unableToShutdownAsynchronousIndexingByTimeout$str() {
        return unableToShutdownAsynchronousIndexingByTimeout;
    }

    @Override
    public final void warnSuspiciousBackendDirectoryCombination(String indexName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnSuspiciousBackendDirectoryCombination$str(), (Object)indexName);
    }

    protected String warnSuspiciousBackendDirectoryCombination$str() {
        return warnSuspiciousBackendDirectoryCombination;
    }

    protected String unableToSerializeLuceneWorks$str() {
        return unableToSerializeLuceneWorks;
    }

    @Override
    public final SearchException unableToSerializeLuceneWorks(Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToSerializeLuceneWorks$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadSerializedLuceneWorks$str() {
        return unableToReadSerializedLuceneWorks;
    }

    @Override
    public final SearchException unableToReadSerializedLuceneWorks(Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToReadSerializedLuceneWorks$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributeNotRecognizedNorSerializable$str() {
        return attributeNotRecognizedNorSerializable;
    }

    @Override
    public final SearchException attributeNotRecognizedNorSerializable(Class<?> attributeType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.attributeNotRecognizedNorSerializable$str(), new ClassFormatter(attributeType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAttributeSerializedRepresentation$str() {
        return unknownAttributeSerializedRepresentation;
    }

    @Override
    public final SearchException unknownAttributeSerializedRepresentation(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAttributeSerializedRepresentation$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadTokenStream$str() {
        return unableToReadTokenStream;
    }

    @Override
    public final SearchException unableToReadTokenStream() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToReadTokenStream$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableStoreToLuceneStore$str() {
        return unableToConvertSerializableStoreToLuceneStore;
    }

    @Override
    public final SearchException unableToConvertSerializableStoreToLuceneStore(String store) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToConvertSerializableStoreToLuceneStore$str(), store));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownNumericFieldType$str() {
        return unknownNumericFieldType;
    }

    @Override
    public final SearchException unknownNumericFieldType(String dataType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNumericFieldType$str(), dataType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conversionFromReaderToStringNotYetImplemented$str() {
        return conversionFromReaderToStringNotYetImplemented;
    }

    @Override
    public final SearchException conversionFromReaderToStringNotYetImplemented() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conversionFromReaderToStringNotYetImplemented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldType$str() {
        return unknownFieldType;
    }

    @Override
    public final SearchException unknownFieldType(Class<?> fieldType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldType$str(), new ClassFormatter(fieldType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSerializeCustomField$str() {
        return cannotSerializeCustomField;
    }

    @Override
    public final SearchException cannotSerializeCustomField(Class<?> fieldType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotSerializeCustomField$str(), new ClassFormatter(fieldType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToSerializeObject$str() {
        return failToSerializeObject;
    }

    @Override
    public final SearchException failToSerializeObject(Class<?> type, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failToSerializeObject$str(), new ClassFormatter(type)), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToDeserializeObject$str() {
        return failToDeserializeObject;
    }

    @Override
    public final SearchException failToDeserializeObject(Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failToDeserializeObject$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeserializeAvroStream$str() {
        return unableToDeserializeAvroStream;
    }

    @Override
    public final SearchException unableToDeserializeAvroStream(Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeserializeAvroStream$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeOperation$str() {
        return cannotDeserializeOperation;
    }

    @Override
    public final SearchException cannotDeserializeOperation(String schema) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotDeserializeOperation$str(), schema));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeField$str() {
        return cannotDeserializeField;
    }

    @Override
    public final SearchException cannotDeserializeField(String schema) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotDeserializeField$str(), schema));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeInAvro$str() {
        return unableToSerializeInAvro;
    }

    @Override
    public final SearchException unableToSerializeInAvro(Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToSerializeInAvro$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeIndexManager$str() {
        return unableToInitializeIndexManager;
    }

    @Override
    public final SearchException unableToInitializeIndexManager(String indexName, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInitializeIndexManager$str(), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void ignoringBackendOptionForIndex(String indexName, String forcedBackend) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringBackendOptionForIndex$str(), (Object)indexName, (Object)forcedBackend);
    }

    protected String ignoringBackendOptionForIndex$str() {
        return ignoringBackendOptionForIndex;
    }

    protected String cannotGetResultSizeWithCriteriaAndRestriction$str() {
        return cannotGetResultSizeWithCriteriaAndRestriction;
    }

    @Override
    public final SearchException cannotGetResultSizeWithCriteriaAndRestriction(String criteria) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGetResultSizeWithCriteriaAndRestriction$str(), criteria));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldLooksBinaryButDecompressionFailed$str() {
        return fieldLooksBinaryButDecompressionFailed;
    }

    @Override
    public final SearchException fieldLooksBinaryButDecompressionFailed(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldLooksBinaryButDecompressionFailed$str(), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestedIndexNotDefined$str() {
        return requestedIndexNotDefined;
    }

    @Override
    public final SearchException requestedIndexNotDefined(String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.requestedIndexNotDefined$str(), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void shuttingDownBackend(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.shuttingDownBackend$str(), (Object)indexName);
    }

    protected String shuttingDownBackend$str() {
        return shuttingDownBackend;
    }

    protected String notAnIndexedType$str() {
        return notAnIndexedType;
    }

    @Override
    public final IllegalArgumentException notAnIndexedType(String entityName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notAnIndexedType$str(), entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexedType$str() {
        return nullIsInvalidIndexedType;
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexedType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullIsInvalidIndexedType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexName$str() {
        return needAtLeastOneIndexName;
    }

    @Override
    public final IllegalArgumentException needAtLeastOneIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.needAtLeastOneIndexName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexedEntityType$str() {
        return needAtLeastOneIndexedEntityType;
    }

    @Override
    public final IllegalArgumentException needAtLeastOneIndexedEntityType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.needAtLeastOneIndexedEntityType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexName$str() {
        return nullIsInvalidIndexName;
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullIsInvalidIndexName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFullTextFilter$str() {
        return unknownFullTextFilter;
    }

    @Override
    public final SearchException unknownFullTextFilter(String filterName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFullTextFilter$str(), filterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String massIndexerUnexpectedErrorMessage$str() {
        return massIndexerUnexpectedErrorMessage;
    }

    @Override
    public final String massIndexerUnexpectedErrorMessage() {
        return String.format(this.getLoggingLocale(), this.massIndexerUnexpectedErrorMessage$str(), new Object[0]);
    }

    protected String ioExceptionOnIndexWriter$str() {
        return ioExceptionOnIndexWriter;
    }

    @Override
    public final String ioExceptionOnIndexWriter() {
        return String.format(this.getLoggingLocale(), this.ioExceptionOnIndexWriter$str(), new Object[0]);
    }

    protected String exceptionDuringIndexMergeOperation$str() {
        return exceptionDuringIndexMergeOperation;
    }

    @Override
    public final String exceptionDuringIndexMergeOperation() {
        return String.format(this.getLoggingLocale(), this.exceptionDuringIndexMergeOperation$str(), new Object[0]);
    }

    @Override
    public final void optimizationSkippedStillBusy(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.optimizationSkippedStillBusy$str(), (Object)indexName);
    }

    protected String optimizationSkippedStillBusy$str() {
        return optimizationSkippedStillBusy;
    }

    @Override
    public final void inconsistentFieldConfiguration(String className, String fieldName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.inconsistentFieldConfiguration$str(), (Object)className, (Object)fieldName);
    }

    protected String inconsistentFieldConfiguration$str() {
        return inconsistentFieldConfiguration;
    }

    @Override
    public final void forceSkipIndexOperationViaInterception(IndexedTypeIdentifier entityType, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.forceSkipIndexOperationViaInterception$str(), (Object)new IndexedTypeIdentifierFormatter(entityType), (Object)type);
    }

    protected String forceSkipIndexOperationViaInterception$str() {
        return forceSkipIndexOperationViaInterception;
    }

    @Override
    public final void forceRemoveOnIndexOperationViaInterception(IndexedTypeIdentifier entityType, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.forceRemoveOnIndexOperationViaInterception$str(), (Object)new IndexedTypeIdentifierFormatter(entityType), (Object)type);
    }

    protected String forceRemoveOnIndexOperationViaInterception$str() {
        return forceRemoveOnIndexOperationViaInterception;
    }

    @Override
    public final void forceUpdateOnIndexOperationViaInterception(IndexedTypeIdentifier entityType, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.forceUpdateOnIndexOperationViaInterception$str(), (Object)new IndexedTypeIdentifierFormatter(entityType), (Object)type);
    }

    protected String forceUpdateOnIndexOperationViaInterception$str() {
        return forceUpdateOnIndexOperationViaInterception;
    }

    protected String targetedFieldNotSpatial$str() {
        return targetedFieldNotSpatial;
    }

    @Override
    public final SearchException targetedFieldNotSpatial(String className, String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.targetedFieldNotSpatial$str(), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByClassBridge$str() {
        return noFieldBridgeInterfaceImplementedByClassBridge;
    }

    @Override
    public final SearchException noFieldBridgeInterfaceImplementedByClassBridge(String implName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noFieldBridgeInterfaceImplementedByClassBridge$str(), implName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateClassBridgeOfType$str() {
        return cannotInstantiateClassBridgeOfType;
    }

    @Override
    public final SearchException cannotInstantiateClassBridgeOfType(String implName, String className, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotInstantiateClassBridgeOfType$str(), implName, className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGuessFieldBridge$str() {
        return unableToGuessFieldBridge;
    }

    @Override
    public final SearchException unableToGuessFieldBridge(String className, String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToGuessFieldBridge$str(), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateSpatial$str() {
        return unableToInstantiateSpatial;
    }

    @Override
    public final SearchException unableToInstantiateSpatial(String className, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInstantiateSpatial$str(), className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noImplementationClassInFieldBridge$str() {
        return noImplementationClassInFieldBridge;
    }

    @Override
    public final SearchException noImplementationClassInFieldBridge(String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noImplementationClassInFieldBridge$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByFieldBridge$str() {
        return noFieldBridgeInterfaceImplementedByFieldBridge;
    }

    @Override
    public final SearchException noFieldBridgeInterfaceImplementedByFieldBridge(String implName, String appliedOnName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noFieldBridgeInterfaceImplementedByFieldBridge$str(), implName, appliedOnName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateFieldBridge$str() {
        return unableToInstantiateFieldBridge;
    }

    @Override
    public final SearchException unableToInstantiateFieldBridge(String appliedOnName, String appliedOnTypeName, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInstantiateFieldBridge$str(), appliedOnName, appliedOnTypeName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldBridgeNotAnInstanceof$str() {
        return fieldBridgeNotAnInstanceof;
    }

    @Override
    public final SearchException fieldBridgeNotAnInstanceof(String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldBridgeNotAnInstanceof$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryWithNoTermsAfterAnalysis$str() {
        return queryWithNoTermsAfterAnalysis;
    }

    @Override
    public final EmptyQueryException queryWithNoTermsAfterAnalysis(String field, String searchTerm) {
        EmptyQueryException result = new EmptyQueryException(String.format(this.getLoggingLocale(), this.queryWithNoTermsAfterAnalysis$str(), field, searchTerm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineClassBridge$str() {
        return unableToDetermineClassBridge;
    }

    @Override
    public final SearchException unableToDetermineClassBridge(String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDetermineClassBridge$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGetInputStreamFromBlob$str() {
        return unableToGetInputStreamFromBlob;
    }

    @Override
    public final SearchException unableToGetInputStreamFromBlob(Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToGetInputStreamFromBlob$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedTikaBridgeType$str() {
        return unsupportedTikaBridgeType;
    }

    @Override
    public final SearchException unsupportedTikaBridgeType(Class<?> objectType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedTikaBridgeType$str(), new ClassFormatter(objectType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileDoesNotExist$str() {
        return fileDoesNotExist;
    }

    @Override
    public final SearchException fileDoesNotExist(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fileDoesNotExist$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsADirectory$str() {
        return fileIsADirectory;
    }

    @Override
    public final SearchException fileIsADirectory(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fileIsADirectory$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsNotReadable$str() {
        return fileIsNotReadable;
    }

    @Override
    public final SearchException fileIsNotReadable(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fileIsNotReadable$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConfigureTikaBridge$str() {
        return unableToConfigureTikaBridge;
    }

    @Override
    public final SearchException unableToConfigureTikaBridge(String bridgeName, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToConfigureTikaBridge$str(), bridgeName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotReadFieldForClass$str() {
        return cannotReadFieldForClass;
    }

    @Override
    public final SearchException cannotReadFieldForClass(String fieldName, String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotReadFieldForClass$str(), fieldName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotExtractCoordinateFromObject$str() {
        return cannotExtractCoordinateFromObject;
    }

    @Override
    public final SearchException cannotExtractCoordinateFromObject(String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotExtractCoordinateFromObject$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotHaveTwoSpatialsWithDefaultOrSameName$str() {
        return cannotHaveTwoSpatialsWithDefaultOrSameName;
    }

    @Override
    public final SearchException cannotHaveTwoSpatialsWithDefaultOrSameName(String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotHaveTwoSpatialsWithDefaultOrSameName$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindCoordinatesNorLatLongForSpatial$str() {
        return cannotFindCoordinatesNorLatLongForSpatial;
    }

    @Override
    public final SearchException cannotFindCoordinatesNorLatLongForSpatial(String spatialName, String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindCoordinatesNorLatLongForSpatial$str(), spatialName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLatitudeDefinition$str() {
        return ambiguousLatitudeDefinition;
    }

    @Override
    public final SearchException ambiguousLatitudeDefinition(String beanXClassName, String firstField, String secondField) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ambiguousLatitudeDefinition$str(), beanXClassName, firstField, secondField));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLongitudeDefinition$str() {
        return ambiguousLongitudeDefinition;
    }

    @Override
    public final SearchException ambiguousLongitudeDefinition(String beanXClassName, String firstField, String secondField) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ambiguousLongitudeDefinition$str(), beanXClassName, firstField, secondField));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToOpenJMSConnection$str() {
        return unableToOpenJMSConnection;
    }

    @Override
    public final SearchException unableToOpenJMSConnection(String indexName, String jmsQueueName, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToOpenJMSConnection$str(), indexName, jmsQueueName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendJMSWork$str() {
        return unableToSendJMSWork;
    }

    @Override
    public final SearchException unableToSendJMSWork(String indexName, String jmsQueueName, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToSendJMSWork$str(), indexName, jmsQueueName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsQueueLookupException$str() {
        return jmsQueueLookupException;
    }

    @Override
    public final SearchException jmsQueueLookupException(String jmsQueueName, String indexName, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.jmsQueueLookupException$str(), jmsQueueName, indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void indexManagerAliasResolved(String alias, Class<?> im) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.indexManagerAliasResolved$str(), (Object)alias, (Object)new ClassFormatter(im));
    }

    protected String indexManagerAliasResolved$str() {
        return indexManagerAliasResolved;
    }

    protected String duplicateDocumentIdFound$str() {
        return duplicateDocumentIdFound;
    }

    @Override
    public final SearchException duplicateDocumentIdFound(String beanXClassName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateDocumentIdFound$str(), beanXClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void indexManagerUsesSerializationService(String indexName, String serializerDescription) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexManagerUsesSerializationService$str(), (Object)indexName, (Object)serializerDescription);
    }

    protected String indexManagerUsesSerializationService$str() {
        return indexManagerUsesSerializationService;
    }

    protected String fieldBridgeNotTwoWay$str() {
        return fieldBridgeNotTwoWay;
    }

    @Override
    public final SearchException fieldBridgeNotTwoWay(Class<? extends FieldBridge> bridgeClass, String fieldName, String typeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldBridgeNotTwoWay$str(), new ClassFormatter(bridgeClass), fieldName, typeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToParseDocument$str() {
        return unableToParseDocument;
    }

    @Override
    public final SearchException unableToParseDocument(Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseDocument$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDocumentIdFoundException$str() {
        return noDocumentIdFoundException;
    }

    @Override
    public final SearchException noDocumentIdFoundException(String entityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noDocumentIdFoundException$str(), entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNullSessionPassedToFullTextSessionCreationException$str() {
        return getNullSessionPassedToFullTextSessionCreationException;
    }

    @Override
    public final IllegalArgumentException getNullSessionPassedToFullTextSessionCreationException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.getNullSessionPassedToFullTextSessionCreationException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNullEntityManagerPassedToFullEntityManagerCreationException$str() {
        return getNullEntityManagerPassedToFullEntityManagerCreationException;
    }

    @Override
    public final IllegalArgumentException getNullEntityManagerPassedToFullEntityManagerCreationException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.getNullEntityManagerPassedToFullEntityManagerCreationException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToNarrowFieldDescriptorException$str() {
        return getUnableToNarrowFieldDescriptorException;
    }

    @Override
    public final ClassCastException getUnableToNarrowFieldDescriptorException(String actualDescriptorType, String type, String expectedType) {
        ClassCastException result = new ClassCastException(String.format(this.getLoggingLocale(), this.getUnableToNarrowFieldDescriptorException$str(), actualDescriptorType, type, expectedType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyNameCannotBeNullException$str() {
        return getPropertyNameCannotBeNullException;
    }

    @Override
    public final IllegalArgumentException getPropertyNameCannotBeNullException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.getPropertyNameCannotBeNullException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getFieldNameCannotBeNullException$str() {
        return getFieldNameCannotBeNullException;
    }

    @Override
    public final IllegalArgumentException getFieldNameCannotBeNullException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.getFieldNameCannotBeNullException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String massIndexerUnableToIndexInstance$str() {
        return massIndexerUnableToIndexInstance;
    }

    @Override
    public final String massIndexerUnableToIndexInstance(String clazz, String value) {
        return String.format(this.getLoggingLocale(), this.massIndexerUnableToIndexInstance$str(), clazz, value);
    }

    protected String entityWithNoShard$str() {
        return entityWithNoShard;
    }

    @Override
    public final SearchException entityWithNoShard(IndexedTypeIdentifier type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.entityWithNoShard$str(), new IndexedTypeIdentifierFormatter(type)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String assertionFailureCannotCastToWorkerBuilderContext$str() {
        return assertionFailureCannotCastToWorkerBuilderContext;
    }

    @Override
    public final SearchException assertionFailureCannotCastToWorkerBuilderContext(Class<?> type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.assertionFailureCannotCastToWorkerBuilderContext$str(), new ClassFormatter(type)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoSessionFactoryInContextException$str() {
        return getNoSessionFactoryInContextException;
    }

    @Override
    public final SearchException getNoSessionFactoryInContextException() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.getNoSessionFactoryInContextException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidShardCountException$str() {
        return getInvalidShardCountException;
    }

    @Override
    public final SearchException getInvalidShardCountException(int value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.getInvalidShardCountException$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidIntegerValueException$str() {
        return getInvalidIntegerValueException;
    }

    @Override
    public final SearchException getInvalidIntegerValueException(String msg, Throwable throwable) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.getInvalidIntegerValueException$str(), msg), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void idHashShardingWithSingleShard() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.idHashShardingWithSingleShard$str(), new Object[0]);
    }

    protected String idHashShardingWithSingleShard$str() {
        return idHashShardingWithSingleShard;
    }

    protected String getUnableToLoadShardingStrategyClassException$str() {
        return getUnableToLoadShardingStrategyClassException;
    }

    @Override
    public final SearchException getUnableToLoadShardingStrategyClassException(String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.getUnableToLoadShardingStrategyClassException$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleServiceImplementationsException$str() {
        return getMultipleServiceImplementationsException;
    }

    @Override
    public final SearchException getMultipleServiceImplementationsException(String service, String foundServices) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.getMultipleServiceImplementationsException$str(), service, foundServices));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoServiceImplementationFoundException$str() {
        return getNoServiceImplementationFoundException;
    }

    @Override
    public final SearchException getNoServiceImplementationFoundException(String service) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.getNoServiceImplementationFoundException$str(), service));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToCreateJGroupsBackendException$str() {
        return getUnableToCreateJGroupsBackendException;
    }

    @Override
    public final SearchException getUnableToCreateJGroupsBackendException(Throwable throwable) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.getUnableToCreateJGroupsBackendException$str(), new Object[0]), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnexpectedServiceStatusException$str() {
        return getUnexpectedServiceStatusException;
    }

    @Override
    public final SearchException getUnexpectedServiceStatusException(String status, String service) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.getUnexpectedServiceStatusException$str(), status, service));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configurationPropertyCantBeEmpty$str() {
        return configurationPropertyCantBeEmpty;
    }

    @Override
    public final SearchException configurationPropertyCantBeEmpty(String key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.configurationPropertyCantBeEmpty$str(), key));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incorrectEditDistance$str() {
        return incorrectEditDistance;
    }

    @Override
    public final SearchException incorrectEditDistance() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incorrectEditDistance$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String entityWithIdNotFound$str() {
        return entityWithIdNotFound;
    }

    @Override
    public final SearchException entityWithIdNotFound(IndexedTypeIdentifier entityType, String id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.entityWithIdNotFound$str(), new IndexedTypeIdentifierFormatter(entityType), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldCompatibleForMoreLikeThis$str() {
        return noFieldCompatibleForMoreLikeThis;
    }

    @Override
    public final SearchException noFieldCompatibleForMoreLikeThis(IndexedTypeIdentifier entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noFieldCompatibleForMoreLikeThis$str(), new IndexedTypeIdentifierFormatter(entityType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnIndexOfEntity$str() {
        return ioExceptionOnIndexOfEntity;
    }

    @Override
    public final SearchException ioExceptionOnIndexOfEntity(IOException e, IndexedTypeIdentifier entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnIndexOfEntity$str(), new IndexedTypeIdentifierFormatter(entityType)), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requireTFIDFSimilarity$str() {
        return requireTFIDFSimilarity;
    }

    @Override
    public final SearchException requireTFIDFSimilarity(IndexedTypeIdentifier entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.requireTFIDFSimilarity$str(), new IndexedTypeIdentifierFormatter(entityType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis$str() {
        return fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis;
    }

    @Override
    public final SearchException fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis(String fieldName, IndexedTypeIdentifier entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis$str(), fieldName, new IndexedTypeIdentifierFormatter(entityType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String classLoaderServiceContainedInProvidedServicesException$str() {
        return classLoaderServiceContainedInProvidedServicesException;
    }

    @Override
    public final SearchException classLoaderServiceContainedInProvidedServicesException() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.classLoaderServiceContainedInProvidedServicesException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serviceRequestedAfterReleasedAllWasCalled$str() {
        return serviceRequestedAfterReleasedAllWasCalled;
    }

    @Override
    public final IllegalStateException serviceRequestedAfterReleasedAllWasCalled() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceRequestedAfterReleasedAllWasCalled$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String providedServicesCannotImplementStartableOrStoppable$str() {
        return providedServicesCannotImplementStartableOrStoppable;
    }

    @Override
    public final SearchException providedServicesCannotImplementStartableOrStoppable(String service, String implementedInterface) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.providedServicesCannotImplementStartableOrStoppable$str(), service, implementedInterface));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String massIndexerExceptionWhileFetchingIds$str() {
        return massIndexerExceptionWhileFetchingIds;
    }

    @Override
    public final String massIndexerExceptionWhileFetchingIds() {
        return String.format(this.getLoggingLocale(), this.massIndexerExceptionWhileFetchingIds$str(), new Object[0]);
    }

    protected String massIndexerExceptionWhileTransformingIds$str() {
        return massIndexerExceptionWhileTransformingIds;
    }

    @Override
    public final String massIndexerExceptionWhileTransformingIds() {
        return String.format(this.getLoggingLocale(), this.massIndexerExceptionWhileTransformingIds$str(), new Object[0]);
    }

    protected String fieldIdCannotBeUsedInMoreLikeThis$str() {
        return fieldIdCannotBeUsedInMoreLikeThis;
    }

    @Override
    public final SearchException fieldIdCannotBeUsedInMoreLikeThis(String fieldName, IndexedTypeIdentifier entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldIdCannotBeUsedInMoreLikeThis$str(), fieldName, new IndexedTypeIdentifierFormatter(entityType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericFieldCannotBeUsedInMoreLikeThis$str() {
        return numericFieldCannotBeUsedInMoreLikeThis;
    }

    @Override
    public final SearchException numericFieldCannotBeUsedInMoreLikeThis(String fieldName, IndexedTypeIdentifier entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.numericFieldCannotBeUsedInMoreLikeThis$str(), fieldName, new IndexedTypeIdentifierFormatter(entityType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleMatchingFieldBridges$str() {
        return multipleMatchingFieldBridges;
    }

    @Override
    public final SearchException multipleMatchingFieldBridges(XMember member, XClass memberType, String listOfFieldBridges) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleMatchingFieldBridges$str(), member, memberType, listOfFieldBridges));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIncludePathConfiguration$str() {
        return invalidIncludePathConfiguration;
    }

    @Override
    public final SearchException invalidIncludePathConfiguration(String member, String clazz, String invalidPaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIncludePathConfiguration$str(), member, clazz, invalidPaths));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPropertyValue$str() {
        return invalidPropertyValue;
    }

    @Override
    public final SearchException invalidPropertyValue(String value, String property) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPropertyValue$str(), value, property));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldNameForMoreLikeThisQuery$str() {
        return unknownFieldNameForMoreLikeThisQuery;
    }

    @Override
    public final SearchException unknownFieldNameForMoreLikeThisQuery(String field, IndexedTypeIdentifier type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldNameForMoreLikeThisQuery$str(), field, new IndexedTypeIdentifierFormatter(type)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsInitialContextException$str() {
        return jmsInitialContextException;
    }

    @Override
    public final SearchException jmsInitialContextException(String jmsConnectionFactoryName, String indexName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.jmsInitialContextException$str(), jmsConnectionFactoryName, indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsQueueFactoryLookupException$str() {
        return jmsQueueFactoryLookupException;
    }

    @Override
    public final SearchException jmsQueueFactoryLookupException(String jmsConnectionFactoryName, String indexName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.jmsQueueFactoryLookupException$str(), jmsConnectionFactoryName, indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String detectInfiniteTypeLoopInIndexedEmbedded$str() {
        return detectInfiniteTypeLoopInIndexedEmbedded;
    }

    @Override
    public final SearchException detectInfiniteTypeLoopInIndexedEmbedded(String elementClass, String parentEntity, String path) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.detectInfiniteTypeLoopInIndexedEmbedded$str(), elementClass, parentEntity, path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String searchIntegratorNotInitialized$str() {
        return searchIntegratorNotInitialized;
    }

    @Override
    public final SearchException searchIntegratorNotInitialized() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchIntegratorNotInitialized$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String searchFactoryReferenceServiceNotFound$str() {
        return searchFactoryReferenceServiceNotFound;
    }

    @Override
    public final SearchException searchFactoryReferenceServiceNotFound() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchFactoryReferenceServiceNotFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parametersShouldNotBeNull$str() {
        return parametersShouldNotBeNull;
    }

    @Override
    public final AssertionFailure parametersShouldNotBeNull(String parameterName) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.parametersShouldNotBeNull$str(), parameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void lockingFailureDuringInitialization(String directoryDescription) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lockingFailureDuringInitialization$str(), (Object)directoryDescription);
    }

    protected String lockingFailureDuringInitialization$str() {
        return lockingFailureDuringInitialization;
    }

    @Override
    public final void logInfoStreamMessage(String componentName, String message) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.logInfoStreamMessage$str(), (Object)componentName, (Object)message);
    }

    protected String logInfoStreamMessage$str() {
        return logInfoStreamMessage;
    }

    protected String booleanQueryWithoutClauses$str() {
        return booleanQueryWithoutClauses;
    }

    @Override
    public final SearchException booleanQueryWithoutClauses() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.booleanQueryWithoutClauses$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalLuceneVersionFormat$str() {
        return illegalLuceneVersionFormat;
    }

    @Override
    public final SearchException illegalLuceneVersionFormat(String property, String luceneErrorMessage) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalLuceneVersionFormat$str(), property, luceneErrorMessage));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String flushIntervalNeedsToBePositive$str() {
        return flushIntervalNeedsToBePositive;
    }

    @Override
    public final SearchException flushIntervalNeedsToBePositive(String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.flushIntervalNeedsToBePositive$str(), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void startingSyncConsumerThread(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingSyncConsumerThread$str(), (Object)indexName);
    }

    protected String startingSyncConsumerThread$str() {
        return startingSyncConsumerThread;
    }

    @Override
    public final void stoppingSyncConsumerThread(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingSyncConsumerThread$str(), (Object)indexName);
    }

    protected String stoppingSyncConsumerThread$str() {
        return stoppingSyncConsumerThread;
    }

    protected String stringEncodedFieldsAreTargetedWithNumericQuery$str() {
        return stringEncodedFieldsAreTargetedWithNumericQuery;
    }

    @Override
    public final SearchException stringEncodedFieldsAreTargetedWithNumericQuery(String query, String numericFields) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.stringEncodedFieldsAreTargetedWithNumericQuery$str(), query, numericFields));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericEncodedFieldsAreTargetedWithStringQuery$str() {
        return numericEncodedFieldsAreTargetedWithStringQuery;
    }

    @Override
    public final SearchException numericEncodedFieldsAreTargetedWithStringQuery(String query, String numericFields) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.numericEncodedFieldsAreTargetedWithStringQuery$str(), query, numericFields));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String targetedEntityTypesNotIndexed$str() {
        return targetedEntityTypesNotIndexed;
    }

    @Override
    public final IllegalArgumentException targetedEntityTypesNotIndexed(String targetedEntities) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.targetedEntityTypesNotIndexed$str(), targetedEntities));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void luceneBackendInitializedSynchronously(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.luceneBackendInitializedSynchronously$str(), (Object)indexName);
    }

    protected String luceneBackendInitializedSynchronously$str() {
        return luceneBackendInitializedSynchronously;
    }

    @Override
    public final void luceneBackendInitializedAsynchronously(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.luceneBackendInitializedAsynchronously$str(), (Object)indexName);
    }

    protected String luceneBackendInitializedAsynchronously$str() {
        return luceneBackendInitializedAsynchronously;
    }

    protected String rangeQueryWithNullToAndFromValue$str() {
        return rangeQueryWithNullToAndFromValue;
    }

    @Override
    public final SearchException rangeQueryWithNullToAndFromValue(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangeQueryWithNullToAndFromValue$str(), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericRangeQueryWithNonNumericToAndFromValues$str() {
        return numericRangeQueryWithNonNumericToAndFromValues;
    }

    @Override
    public final SearchException numericRangeQueryWithNonNumericToAndFromValues(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.numericRangeQueryWithNonNumericToAndFromValues$str(), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownEncodingType$str() {
        return unknownEncodingType;
    }

    @Override
    public final AssertionFailure unknownEncodingType(String encoding) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.unknownEncodingType$str(), encoding));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidStringDateFieldInDocument$str() {
        return invalidStringDateFieldInDocument;
    }

    @Override
    public final SearchException invalidStringDateFieldInDocument(String fieldName, String value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidStringDateFieldInDocument$str(), fieldName, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleFactoryMethodsInClass$str() {
        return multipleFactoryMethodsInClass;
    }

    @Override
    public final SearchException multipleFactoryMethodsInClass(String className) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleFactoryMethodsInClass$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPublicNoArgConstructor$str() {
        return noPublicNoArgConstructor;
    }

    @Override
    public final SearchException noPublicNoArgConstructor(String componentName, Class<?> clazz) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noPublicNoArgConstructor$str(), componentName, new ClassFormatter(clazz)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String factoryMethodsMustReturnAnObject$str() {
        return factoryMethodsMustReturnAnObject;
    }

    @Override
    public final SearchException factoryMethodsMustReturnAnObject(String className, String methodName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.factoryMethodsMustReturnAnObject$str(), className, methodName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToAccessMethod$str() {
        return unableToAccessMethod;
    }

    @Override
    public final SearchException unableToAccessMethod(String className, String methodName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToAccessMethod$str(), className, methodName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String exceptionDuringFactoryMethodExecution$str() {
        return exceptionDuringFactoryMethodExecution;
    }

    @Override
    public final SearchException exceptionDuringFactoryMethodExecution(Exception e, String className, String methodName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.exceptionDuringFactoryMethodExecution$str(), className, methodName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldTriesToOverrideIdFieldSettings$str() {
        return fieldTriesToOverrideIdFieldSettings;
    }

    @Override
    public final SearchException fieldTriesToOverrideIdFieldSettings(String className, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldTriesToOverrideIdFieldSettings$str(), className, propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void workListShouldNeverBeEmpty(String stackTrace) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.workListShouldNeverBeEmpty$str(), (Object)stackTrace);
    }

    protected String workListShouldNeverBeEmpty$str() {
        return workListShouldNeverBeEmpty;
    }

    @Override
    public final void singleTermDeleteDisabled(String indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.singleTermDeleteDisabled$str(), (Object)indexName);
    }

    protected String singleTermDeleteDisabled$str() {
        return singleTermDeleteDisabled;
    }

    protected String unsupportedErrorHandlerConfigurationValueType$str() {
        return unsupportedErrorHandlerConfigurationValueType;
    }

    @Override
    public final SearchException unsupportedErrorHandlerConfigurationValueType(Class<?> errorHandlerValueType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedErrorHandlerConfigurationValueType$str(), new ClassFormatter(errorHandlerValueType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSetFilterParameter$str() {
        return unableToSetFilterParameter;
    }

    @Override
    public final SearchException unableToSetFilterParameter(Class<?> filterClass, String parameterName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToSetFilterParameter$str(), new ClassFormatter(filterClass), parameterName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInitializeDirectoryProvider$str() {
        return cannotInitializeDirectoryProvider;
    }

    @Override
    public final SearchException cannotInitializeDirectoryProvider(Class<? extends DirectoryProvider> directoryProviderType, String indexName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotInitializeDirectoryProvider$str(), new ClassFormatter(directoryProviderType), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexBasePathRequiredForLockingStrategy$str() {
        return indexBasePathRequiredForLockingStrategy;
    }

    @Override
    public final SearchException indexBasePathRequiredForLockingStrategy(String strategy) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexBasePathRequiredForLockingStrategy$str(), strategy));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownIndexingMode$str() {
        return unknownIndexingMode;
    }

    @Override
    public final SearchException unknownIndexingMode(String indexingMode) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownIndexingMode$str(), indexingMode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownDocValuesTypeType$str() {
        return unknownDocValuesTypeType;
    }

    @Override
    public final SearchException unknownDocValuesTypeType(String docValuesType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownDocValuesTypeType$str(), docValuesType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedBinaryDocValuesTypeType$str() {
        return unexpectedBinaryDocValuesTypeType;
    }

    @Override
    public final SearchException unexpectedBinaryDocValuesTypeType(String docValuesType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedBinaryDocValuesTypeType$str(), docValuesType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedNumericDocValuesTypeType$str() {
        return unexpectedNumericDocValuesTypeType;
    }

    @Override
    public final SearchException unexpectedNumericDocValuesTypeType(String docValuesType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedNumericDocValuesTypeType$str(), docValuesType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void loadingNonExistentField(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.loadingNonExistentField$str(), (Object)name);
    }

    protected String loadingNonExistentField$str() {
        return loadingNonExistentField;
    }

    protected String unableToDeleteByQuery$str() {
        return unableToDeleteByQuery;
    }

    @Override
    public final SearchException unableToDeleteByQuery(IndexedTypeIdentifier entityType, DeletionQuery deletionQuery, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteByQuery$str(), new IndexedTypeIdentifierFormatter(entityType), deletionQuery), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void givenCriteriaObjectCannotBeApplied() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.givenCriteriaObjectCannotBeApplied$str(), new Object[0]);
    }

    protected String givenCriteriaObjectCannotBeApplied$str() {
        return givenCriteriaObjectCannotBeApplied;
    }

    protected String unknownDeletionQueryKeySpecified$str() {
        return unknownDeletionQueryKeySpecified;
    }

    @Override
    public final SearchException unknownDeletionQueryKeySpecified(int queryKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownDeletionQueryKeySpecified$str(), queryKey));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericFieldAnnotationWithoutMatchingField$str() {
        return numericFieldAnnotationWithoutMatchingField;
    }

    @Override
    public final SearchException numericFieldAnnotationWithoutMatchingField(IndexedTypeIdentifier entityType, String memberName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.numericFieldAnnotationWithoutMatchingField$str(), new IndexedTypeIdentifierFormatter(entityType), memberName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String facetAnnotationWithoutMatchingField$str() {
        return facetAnnotationWithoutMatchingField;
    }

    @Override
    public final SearchException facetAnnotationWithoutMatchingField(String className, String memberName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.facetAnnotationWithoutMatchingField$str(), className, memberName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFieldTypeForFaceting$str() {
        return unsupportedFieldTypeForFaceting;
    }

    @Override
    public final SearchException unsupportedFieldTypeForFaceting(String valueType, String className, String memberName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedFieldTypeForFaceting$str(), valueType, className, memberName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorDuringFacetingIndexing$str() {
        return errorDuringFacetingIndexing;
    }

    @Override
    public final SearchException errorDuringFacetingIndexing(Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorDuringFacetingIndexing$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericDateFacetForNonNumericField$str() {
        return numericDateFacetForNonNumericField;
    }

    @Override
    public final SearchException numericDateFacetForNonNumericField(String facetName, String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.numericDateFacetForNonNumericField$str(), facetName, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldNameForFaceting$str() {
        return unknownFieldNameForFaceting;
    }

    @Override
    public final SearchException unknownFieldNameForFaceting(String facetName, String facetFieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldNameForFaceting$str(), facetName, facetFieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedParameterTypeForRangeFaceting$str() {
        return unsupportedParameterTypeForRangeFaceting;
    }

    @Override
    public final SearchException unsupportedParameterTypeForRangeFaceting(String facetRangeParameterType, String supportedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedParameterTypeForRangeFaceting$str(), facetRangeParameterType, supportedTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noStartOrEndSpecifiedForRangeQuery$str() {
        return noStartOrEndSpecifiedForRangeQuery;
    }

    @Override
    public final SearchException noStartOrEndSpecifiedForRangeQuery(String facetRequestName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noStartOrEndSpecifiedForRangeQuery$str(), facetRequestName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rangeDefinitionOrderRequestedForDiscreteFacetRequest$str() {
        return rangeDefinitionOrderRequestedForDiscreteFacetRequest;
    }

    @Override
    public final SearchException rangeDefinitionOrderRequestedForDiscreteFacetRequest() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangeDefinitionOrderRequestedForDiscreteFacetRequest$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attemptToCreateFacetingRequestForUnindexedEntity$str() {
        return attemptToCreateFacetingRequestForUnindexedEntity;
    }

    @Override
    public final SearchException attemptToCreateFacetingRequestForUnindexedEntity(String entityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.attemptToCreateFacetingRequestForUnindexedEntity$str(), entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attemptToFacetOnAnalyzedField$str() {
        return attemptToFacetOnAnalyzedField;
    }

    @Override
    public final SearchException attemptToFacetOnAnalyzedField(String fieldName, String entityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.attemptToFacetOnAnalyzedField$str(), fieldName, entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executingLuceneQuery(Query luceneQuery) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executingLuceneQuery$str(), (Object)luceneQuery);
    }

    protected String executingLuceneQuery$str() {
        return executingLuceneQuery;
    }

    protected String serializationProviderNotFoundException$str() {
        return serializationProviderNotFoundException;
    }

    @Override
    public final SearchException serializationProviderNotFoundException(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.serializationProviderNotFoundException$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return transactionNotActiveWhileProducingIdsForBatchIndexing;
    }

    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(IndexedTypeIdentifier entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionNotActiveWhileProducingIdsForBatchIndexing$str(), new IndexedTypeIdentifierFormatter(entityType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backendNonTransactional$str() {
        return backendNonTransactional;
    }

    @Override
    public final SearchException backendNonTransactional(String indexName, String backend) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendNonTransactional$str(), indexName, backend));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cantQueryUnindexedType$str() {
        return cantQueryUnindexedType;
    }

    @Override
    public final SearchException cantQueryUnindexedType(String canonicalEntityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cantQueryUnindexedType$str(), canonicalEntityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String assertionNotLoadingUTF8Charset$str() {
        return assertionNotLoadingUTF8Charset;
    }

    @Override
    public final AssertionFailure assertionNotLoadingUTF8Charset(UnsupportedEncodingException e) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.assertionNotLoadingUTF8Charset$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sourceDirectoryNotExisting$str() {
        return sourceDirectoryNotExisting;
    }

    @Override
    public final SearchException sourceDirectoryNotExisting(String directory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sourceDirectoryNotExisting$str(), directory));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String directoryIsNotReadable$str() {
        return directoryIsNotReadable;
    }

    @Override
    public final SearchException directoryIsNotReadable(String directory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.directoryIsNotReadable$str(), directory));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distanceSortRequiresSpatialField$str() {
        return distanceSortRequiresSpatialField;
    }

    @Override
    public final SearchException distanceSortRequiresSpatialField(String field) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.distanceSortRequiresSpatialField$str(), field));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sortRequiresIndexedField$str() {
        return sortRequiresIndexedField;
    }

    @Override
    public final SearchException sortRequiresIndexedField(Class<?> sortFieldType, String field) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortRequiresIndexedField$str(), new ClassFormatter(sortFieldType), field));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnMultiReaderRefresh$str() {
        return ioExceptionOnMultiReaderRefresh;
    }

    @Override
    public final SearchException ioExceptionOnMultiReaderRefresh(IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnMultiReaderRefresh$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateUninvertingReader$str() {
        return couldNotCreateUninvertingReader;
    }

    @Override
    public final SearchException couldNotCreateUninvertingReader(DirectoryReader reader, IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.couldNotCreateUninvertingReader$str(), reader), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void readerTypeUnsupportedForInverting(Class<? extends IndexReader> readerClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.readerTypeUnsupportedForInverting$str(), (Object)new ClassFormatter(readerClass));
    }

    protected String readerTypeUnsupportedForInverting$str() {
        return readerTypeUnsupportedForInverting;
    }

    protected String sortFieldTypeUnsupported$str() {
        return sortFieldTypeUnsupported;
    }

    @Override
    public final SearchException sortFieldTypeUnsupported(String fieldName, SortField.Type type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortFieldTypeUnsupported$str(), fieldName, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void deprecatedConfigurationPropertyIsIgnored(String string) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedConfigurationPropertyIsIgnored$str(), (Object)string);
    }

    protected String deprecatedConfigurationPropertyIsIgnored$str() {
        return deprecatedConfigurationPropertyIsIgnored;
    }

    @Override
    public final void uncoveredSortsRequested(IndexedTypeIdentifier entityType, String indexName, String uncoveredSorts) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.uncoveredSortsRequested$str(), (Object)new IndexedTypeIdentifierFormatter(entityType), (Object)indexName, (Object)uncoveredSorts);
    }

    protected String uncoveredSortsRequested$str() {
        return uncoveredSortsRequested;
    }

    protected String invalidNullMarkerForDouble$str() {
        return invalidNullMarkerForDouble;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForDouble(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForDouble$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForFloat$str() {
        return invalidNullMarkerForFloat;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForFloat(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForFloat$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForInteger$str() {
        return invalidNullMarkerForInteger;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForInteger(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForInteger$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForLong$str() {
        return invalidNullMarkerForLong;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForLong(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForLong$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSearchOnNullValueWithoutFieldBridge$str() {
        return unableToSearchOnNullValueWithoutFieldBridge;
    }

    @Override
    public final SearchException unableToSearchOnNullValueWithoutFieldBridge(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToSearchOnNullValueWithoutFieldBridge$str(), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parseException$str() {
        return parseException;
    }

    @Override
    public final SearchException parseException(String text, Class<?> readerClass, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.parseException$str(), text, new ClassFormatter(readerClass)), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String valueTooLargeForConversionException$str() {
        return valueTooLargeForConversionException;
    }

    @Override
    public final SearchException valueTooLargeForConversionException(Class<?> type, Object duration, Exception ae) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.valueTooLargeForConversionException$str(), new ClassFormatter(type), duration), ae);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String inconsistentSortableFieldConfigurationForSharedIndex$str() {
        return inconsistentSortableFieldConfigurationForSharedIndex;
    }

    @Override
    public final SearchException inconsistentSortableFieldConfigurationForSharedIndex(String indexName, String requestedSortFields) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentSortableFieldConfigurationForSharedIndex$str(), indexName, requestedSortFields));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sortableFieldRefersToUndefinedField$str() {
        return sortableFieldRefersToUndefinedField;
    }

    @Override
    public final SearchException sortableFieldRefersToUndefinedField(IndexedTypeIdentifier entityType, String property, String sortedFieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortableFieldRefersToUndefinedField$str(), new IndexedTypeIdentifierFormatter(entityType), property, sortedFieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String severalNumericFieldAnnotationsForSameField$str() {
        return severalNumericFieldAnnotationsForSameField;
    }

    @Override
    public final SearchException severalNumericFieldAnnotationsForSameField(IndexedTypeIdentifier entityType, String memberName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.severalNumericFieldAnnotationsForSameField$str(), new IndexedTypeIdentifierFormatter(entityType), memberName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String uncoveredSortsRequestedWithUninvertingNotAllowed$str() {
        return uncoveredSortsRequestedWithUninvertingNotAllowed;
    }

    @Override
    public final SearchException uncoveredSortsRequestedWithUninvertingNotAllowed(IndexedTypeIdentifier entityType, String indexName, String uncoveredSorts) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uncoveredSortsRequestedWithUninvertingNotAllowed$str(), new IndexedTypeIdentifierFormatter(entityType), indexName, uncoveredSorts));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRunLuceneQueryTargetingEntityIndexedWithNonLuceneIndexManager$str() {
        return cannotRunLuceneQueryTargetingEntityIndexedWithNonLuceneIndexManager;
    }

    @Override
    public final SearchException cannotRunLuceneQueryTargetingEntityIndexedWithNonLuceneIndexManager(IndexedTypeIdentifier entityType, String query) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotRunLuceneQueryTargetingEntityIndexedWithNonLuceneIndexManager$str(), new IndexedTypeIdentifierFormatter(entityType), query));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void timedOutWaitingShutdown(String indexName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.timedOutWaitingShutdown$str(), (Object)indexName);
    }

    protected String timedOutWaitingShutdown$str() {
        return timedOutWaitingShutdown;
    }

    @Override
    public final void closingIndexWriter(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.closingIndexWriter$str(), (Object)indexName);
    }

    protected String closingIndexWriter$str() {
        return closingIndexWriter;
    }

    protected String analyzerReferenceNotInitialized$str() {
        return analyzerReferenceNotInitialized;
    }

    @Override
    public final SearchException analyzerReferenceNotInitialized(String fieldName, String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerReferenceNotInitialized$str(), fieldName, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexManagerTypeRequiredToBuildFieldBridge$str() {
        return indexManagerTypeRequiredToBuildFieldBridge;
    }

    @Override
    public final SearchException indexManagerTypeRequiredToBuildFieldBridge(String className, String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerTypeRequiredToBuildFieldBridge$str(), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sortTypeDoesNotMatchFieldType$str() {
        return sortTypeDoesNotMatchFieldType;
    }

    @Override
    public final SearchException sortTypeDoesNotMatchFieldType(String sortType, String fieldType, String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortTypeDoesNotMatchFieldType$str(), sortType, fieldType, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String analyzerReferenceIsNotRemote$str() {
        return analyzerReferenceIsNotRemote;
    }

    @Override
    public final SearchException analyzerReferenceIsNotRemote(AnalyzerReference analyzerReference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerReferenceIsNotRemote$str(), analyzerReference));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String analyzerReferenceIsNotLucene$str() {
        return analyzerReferenceIsNotLucene;
    }

    @Override
    public final SearchException analyzerReferenceIsNotLucene(AnalyzerReference analyzerReference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerReferenceIsNotLucene$str(), analyzerReference));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String lazyLuceneAnalyzerReferenceNotInitialized$str() {
        return lazyLuceneAnalyzerReferenceNotInitialized;
    }

    @Override
    public final SearchException lazyLuceneAnalyzerReferenceNotInitialized(LuceneAnalyzerReference reference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.lazyLuceneAnalyzerReferenceNotInitialized$str(), reference));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String remoteAnalyzerNotInitialized$str() {
        return remoteAnalyzerNotInitialized;
    }

    @Override
    public final SearchException remoteAnalyzerNotInitialized(RemoteAnalyzerReference analyzerReference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.remoteAnalyzerNotInitialized$str(), analyzerReference));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String lazyRemoteAnalyzerReferenceNotInitialized$str() {
        return lazyRemoteAnalyzerReferenceNotInitialized;
    }

    @Override
    public final SearchException lazyRemoteAnalyzerReferenceNotInitialized(RemoteAnalyzerReference reference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.lazyRemoteAnalyzerReferenceNotInitialized$str(), reference));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedProjectionConstant$str() {
        return unexpectedProjectionConstant;
    }

    @Override
    public final SearchException unexpectedProjectionConstant(String constantName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedProjectionConstant$str(), constantName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void deprecatedBackendName() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedBackendName$str(), new Object[0]);
    }

    protected String deprecatedBackendName$str() {
        return deprecatedBackendName;
    }

    @Override
    public final void usingSerializationService(String serializerDescription) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.usingSerializationService$str(), (Object)serializerDescription);
    }

    protected String usingSerializationService$str() {
        return usingSerializationService;
    }

    protected String couldNotAnalyzeSortableField$str() {
        return couldNotAnalyzeSortableField;
    }

    @Override
    public final SearchException couldNotAnalyzeSortableField(String fieldName, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.couldNotAnalyzeSortableField$str(), fieldName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void multipleTermsInAnalyzedSortableField(String fieldName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multipleTermsInAnalyzedSortableField$str(), (Object)fieldName);
    }

    protected String multipleTermsInAnalyzedSortableField$str() {
        return multipleTermsInAnalyzedSortableField;
    }

    @Override
    public final void timedOutWaitingShutdownOfReaderProvider(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.timedOutWaitingShutdownOfReaderProvider$str(), (Object)indexName);
    }

    protected String timedOutWaitingShutdownOfReaderProvider$str() {
        return timedOutWaitingShutdownOfReaderProvider;
    }

    protected String projectingNonStoredField$str() {
        return projectingNonStoredField;
    }

    @Override
    public final SearchException projectingNonStoredField(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectingNonStoredField$str(), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullMarkerInvalidFormat$str() {
        return nullMarkerInvalidFormat;
    }

    @Override
    public final SearchException nullMarkerInvalidFormat(String proposedTokenValue, String fieldName, String invalidFormatMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullMarkerInvalidFormat$str(), proposedTokenValue, fieldName, invalidFormatMessage), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexNamesCollisionDetected$str() {
        return indexNamesCollisionDetected;
    }

    @Override
    public final SearchException indexNamesCollisionDetected(String string) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexNamesCollisionDetected$str(), string));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateBridgeDefinedField$str() {
        return cannotCreateBridgeDefinedField;
    }

    @Override
    public final SearchException cannotCreateBridgeDefinedField(Class<?> backend, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateBridgeDefinedField$str(), new ClassFormatter(backend)), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String analyzerDefinitionNamingConflict$str() {
        return analyzerDefinitionNamingConflict;
    }

    @Override
    public final SearchException analyzerDefinitionNamingConflict(String analyzerDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerDefinitionNamingConflict$str(), analyzerDefinitionName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cantQueryUnconfiguredType$str() {
        return cantQueryUnconfiguredType;
    }

    @Override
    public final SearchException cantQueryUnconfiguredType(String canonicalEntityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cantQueryUnconfiguredType$str(), canonicalEntityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String targetedEntityTypesNotConfigured$str() {
        return targetedEntityTypesNotConfigured;
    }

    @Override
    public final IllegalArgumentException targetedEntityTypesNotConfigured(String targetedEntities) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.targetedEntityTypesNotConfigured$str(), targetedEntities));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryWithNoIndexedType$str() {
        return queryWithNoIndexedType;
    }

    @Override
    public final SearchException queryWithNoIndexedType() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.queryWithNoIndexedType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String simpleQueryParserDoesNotSupportNullQueries$str() {
        return simpleQueryParserDoesNotSupportNullQueries;
    }

    @Override
    public final SearchException simpleQueryParserDoesNotSupportNullQueries() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.simpleQueryParserDoesNotSupportNullQueries$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void fileDeleteFailureIgnored(IOException e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.fileDeleteFailureIgnored$str(), new Object[0]);
    }

    protected String fileDeleteFailureIgnored$str() {
        return fileDeleteFailureIgnored;
    }

    protected String conflictingParameterDefined$str() {
        return conflictingParameterDefined;
    }

    @Override
    public final SearchException conflictingParameterDefined(String name, String value1, String value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingParameterDefined$str(), name, value1, value2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompleteEntityInfo$str() {
        return incompleteEntityInfo;
    }

    @Override
    public final SearchException incompleteEntityInfo(IndexedTypeIdentifier entityType, Object id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteEntityInfo$str(), new IndexedTypeIdentifierFormatter(entityType), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String beanResolverContainedInProvidedServicesException$str() {
        return beanResolverContainedInProvidedServicesException;
    }

    @Override
    public final SearchException beanResolverContainedInProvidedServicesException() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.beanResolverContainedInProvidedServicesException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fullTextFilterDefinitionNamingConflict$str() {
        return fullTextFilterDefinitionNamingConflict;
    }

    @Override
    public final SearchException fullTextFilterDefinitionNamingConflict(String filterDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fullTextFilterDefinitionNamingConflict$str(), filterDefinitionName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String normalizerDefinitionNamingConflict$str() {
        return normalizerDefinitionNamingConflict;
    }

    @Override
    public final SearchException normalizerDefinitionNamingConflict(String normalizerDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.normalizerDefinitionNamingConflict$str(), normalizerDefinitionName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotReferenceAnalyzerAndNormalizer$str() {
        return cannotReferenceAnalyzerAndNormalizer;
    }

    @Override
    public final SearchException cannotReferenceAnalyzerAndNormalizer(IndexedTypeIdentifier entityType, String relativeFieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotReferenceAnalyzerAndNormalizer$str(), new IndexedTypeIdentifierFormatter(entityType), relativeFieldPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidEmptyNormalizerDefinition$str() {
        return invalidEmptyNormalizerDefinition;
    }

    @Override
    public final SearchException invalidEmptyNormalizerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEmptyNormalizerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void normalizerProducedMultipleTokens(String normalizerName, int token) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.normalizerProducedMultipleTokens$str(), (Object)normalizerName, (Object)token);
    }

    protected String normalizerProducedMultipleTokens$str() {
        return normalizerProducedMultipleTokens;
    }

    @Override
    public final void sortableFieldWithNonNormalizerAnalyzer(IndexedTypeIdentifier entityType, String absoluteFieldPath) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.sortableFieldWithNonNormalizerAnalyzer$str(), (Object)new IndexedTypeIdentifierFormatter(entityType), (Object)absoluteFieldPath);
    }

    protected String sortableFieldWithNonNormalizerAnalyzer$str() {
        return sortableFieldWithNonNormalizerAnalyzer;
    }

    @Override
    public final void usingDeprecatedNameForRamDirectoryProvider() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingDeprecatedNameForRamDirectoryProvider$str(), new Object[0]);
    }

    protected String usingDeprecatedNameForRamDirectoryProvider$str() {
        return usingDeprecatedNameForRamDirectoryProvider;
    }

    protected String incompatibleEntityManagerFactory$str() {
        return incompatibleEntityManagerFactory;
    }

    @Override
    public final SearchException incompatibleEntityManagerFactory(String emfClassName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompatibleEntityManagerFactory$str(), emfClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String someTargetedEntityTypesNotConfigured$str() {
        return someTargetedEntityTypesNotConfigured;
    }

    @Override
    public final IllegalArgumentException someTargetedEntityTypesNotConfigured(String targetedEntities) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.someTargetedEntityTypesNotConfigured$str(), targetedEntities));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String someTargetedEntityTypesNotIndexed$str() {
        return someTargetedEntityTypesNotIndexed;
    }

    @Override
    public final IllegalArgumentException someTargetedEntityTypesNotIndexed(String targetedEntities) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.someTargetedEntityTypesNotIndexed$str(), targetedEntities));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBePositiveOrZero$str() {
        return mustBePositiveOrZero;
    }

    @Override
    public final IllegalArgumentException mustBePositiveOrZero(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustBePositiveOrZero$str(), objectDescription));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return minimumShouldMatchMinimumOutOfBounds;
    }

    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(int totalShouldClauseNumber, int minimum) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return minimumShouldMatchConflictingConstraints;
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAnalyzerForOverride$str() {
        return unknownAnalyzerForOverride;
    }

    @Override
    public final SearchException unknownAnalyzerForOverride(String analyzerName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAnalyzerForOverride$str(), analyzerName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConversionFromLuceneAnalyzer$str() {
        return invalidConversionFromLuceneAnalyzer;
    }

    @Override
    public final SearchException invalidConversionFromLuceneAnalyzer(LuceneAnalyzerReference reference, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidConversionFromLuceneAnalyzer$str(), reference), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(String name, InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.interruptedWhileWaitingForIndexActivity$str(), (Object)name);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    @Override
    public final void illegalObjectRetrievedFromMessage(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    @Override
    public final AssertionFailure unknownResolution(String resolution) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.unknownResolution$str(), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFacetRangeParameter$str() {
        return unsupportedFacetRangeParameter;
    }

    @Override
    public final SearchException unsupportedFacetRangeParameter(String type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedFacetRangeParameter$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String projectingFieldWithoutTwoWayFieldBridge$str() {
        return projectingFieldWithoutTwoWayFieldBridge;
    }

    @Override
    public final SearchException projectingFieldWithoutTwoWayFieldBridge(String fieldName, Class<?> fieldBridgeClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectingFieldWithoutTwoWayFieldBridge$str(), fieldName, fieldBridgeClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedNullTokenType$str() {
        return unsupportedNullTokenType;
    }

    @Override
    public final SearchException unsupportedNullTokenType(IndexedTypeIdentifier entityName, String fieldName, Class<?> tokenType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedNullTokenType$str(), new IndexedTypeIdentifierFormatter(entityName), fieldName, tokenType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLuceneAnalyzerDefinitionProvider$str() {
        return invalidLuceneAnalyzerDefinitionProvider;
    }

    @Override
    public final SearchException invalidLuceneAnalyzerDefinitionProvider(String providerClassName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLuceneAnalyzerDefinitionProvider$str(), providerClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

