/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.pathmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.server.pathmap.PathSpecGroup;

@ManagedObject(value="Path Mappings")
public class PathMappings<E>
implements Iterable<MappedResource<E>>,
Dumpable {
    private static final Logger LOG = Log.getLogger(PathMappings.class);
    private List<MappedResource<E>> mappings = new ArrayList<MappedResource<E>>();
    private MappedResource<E> defaultResource = null;

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this.mappings});
    }

    @ManagedAttribute(value="mappings", readonly=true)
    public List<MappedResource<E>> getMappings() {
        return this.mappings;
    }

    public void reset() {
        this.mappings.clear();
    }

    public MappedResource<E> getMatch(String path) {
        int len = this.mappings.size();
        for (int i = 0; i < len; ++i) {
            MappedResource<E> mr = this.mappings.get(i);
            if (!mr.getPathSpec().matches(path)) continue;
            return mr;
        }
        return this.defaultResource;
    }

    @Override
    public Iterator<MappedResource<E>> iterator() {
        return this.mappings.iterator();
    }

    public void put(PathSpec pathSpec, E resource) {
        MappedResource<E> entry = new MappedResource<E>(pathSpec, resource);
        if (pathSpec.group == PathSpecGroup.DEFAULT) {
            this.defaultResource = entry;
        }
        this.mappings.add(entry);
        LOG.debug("Added {} to {}", new Object[]{entry, this});
        Collections.sort(this.mappings);
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getSimpleName(), this.mappings.size());
    }

    @ManagedObject(value="Mapped Resource")
    public static class MappedResource<E>
    implements Comparable<MappedResource<E>> {
        private final PathSpec pathSpec;
        private final E resource;

        public MappedResource(PathSpec pathSpec, E resource) {
            this.pathSpec = pathSpec;
            this.resource = resource;
        }

        @Override
        public int compareTo(MappedResource<E> other) {
            return this.pathSpec.compareTo(other.pathSpec);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MappedResource other = (MappedResource)obj;
            return !(this.pathSpec == null ? other.pathSpec != null : !this.pathSpec.equals(other.pathSpec));
        }

        @ManagedAttribute(value="path spec", readonly=true)
        public PathSpec getPathSpec() {
            return this.pathSpec;
        }

        @ManagedAttribute(value="resource", readonly=true)
        public E getResource() {
            return this.resource;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pathSpec == null ? 0 : this.pathSpec.hashCode());
            return result;
        }

        public String toString() {
            return String.format("MappedResource[pathSpec=%s,resource=%s]", this.pathSpec, this.resource);
        }
    }
}

