/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.DeflateFrameExtension;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.FragmentExtension;
import org.eclipse.jetty.websocket.IdentityExtension;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnectionD00;
import org.eclipse.jetty.websocket.WebSocketConnectionD06;
import org.eclipse.jetty.websocket.WebSocketConnectionD10;

public class WebSocketFactory {
    private final Map<String, Class<? extends Extension>> _extensionClasses = new HashMap<String, Class<? extends Extension>>();
    private final Acceptor _acceptor;
    private WebSocketBuffers _buffers;
    private int _maxIdleTime;

    public WebSocketFactory(Acceptor acceptor) {
        this(acceptor, 65536);
    }

    public WebSocketFactory(Acceptor acceptor, int bufferSize) {
        this._extensionClasses.put("identity", IdentityExtension.class);
        this._extensionClasses.put("fragment", FragmentExtension.class);
        this._extensionClasses.put("x-deflate-frame", DeflateFrameExtension.class);
        this._maxIdleTime = 300000;
        this._buffers = new WebSocketBuffers(bufferSize);
        this._acceptor = acceptor;
    }

    public Map<String, Class<? extends Extension>> getExtensionClassesMap() {
        return this._extensionClasses;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getBufferSize() {
        return this._buffers.getBufferSize();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize != this.getBufferSize()) {
            this._buffers = new WebSocketBuffers(bufferSize);
        }
    }

    public void upgrade(HttpServletRequest request, HttpServletResponse response, WebSocket websocket, String protocol) throws IOException {
        AbstractConnection connection;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("!Upgrade:websocket");
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            throw new IllegalStateException("!HTTP/1.1");
        }
        int draft = request.getIntHeader("Sec-WebSocket-Version");
        if (draft < 0) {
            draft = request.getIntHeader("Sec-WebSocket-Draft");
        }
        HttpConnection http = HttpConnection.getCurrentConnection();
        ConnectedEndPoint endp = (ConnectedEndPoint)http.getEndPoint();
        ArrayList<String> extensions_requested = new ArrayList<String>();
        Enumeration e = request.getHeaders("Sec-WebSocket-Extensions");
        while (e.hasMoreElements()) {
            QuotedStringTokenizer tok = new QuotedStringTokenizer((String)e.nextElement(), ",");
            while (tok.hasMoreTokens()) {
                extensions_requested.add(tok.nextToken());
            }
        }
        switch (draft) {
            case -1: 
            case 0: {
                List<Extension> extensions = Collections.emptyList();
                connection = new WebSocketConnectionD00(websocket, (EndPoint)endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol);
                break;
            }
            case 6: {
                List<Extension> extensions = Collections.emptyList();
                connection = new WebSocketConnectionD06(websocket, (EndPoint)endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                List<Extension> extensions = this.initExtensions(extensions_requested, 5, 5, 3);
                connection = new WebSocketConnectionD10(websocket, (EndPoint)endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol, extensions, draft);
                break;
            }
            default: {
                Log.warn((String)("Unsupported Websocket version: " + draft));
                throw new HttpException(400, "Unsupported draft specification: " + draft);
            }
        }
        connection.handshake(request, response, protocol);
        response.flushBuffer();
        connection.fillBuffersFrom(((HttpParser)http.getParser()).getHeaderBuffer());
        connection.fillBuffersFrom(((HttpParser)http.getParser()).getBodyBuffer());
        request.setAttribute("org.eclipse.jetty.io.Connection", (Object)connection);
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            String origin = request.getHeader("Sec-WebSocket-Origin");
            if (origin == null) {
                origin = request.getHeader("Origin");
            }
            if (!this._acceptor.checkOrigin(request, origin)) {
                response.sendError(403);
                return false;
            }
            WebSocket websocket = null;
            String protocol = request.getHeader("Sec-WebSocket-Protocol");
            if (protocol == null) {
                protocol = request.getHeader("WebSocket-Protocol");
            }
            for (String p : this.parseProtocols(protocol)) {
                websocket = this._acceptor.doWebSocketConnect(request, p);
                if (websocket == null) continue;
                protocol = p;
                break;
            }
            if (websocket == null) {
                response.sendError(503);
                return false;
            }
            this.upgrade(request, response, websocket, protocol);
            return true;
        }
        return false;
    }

    public List<Extension> initExtensions(List<String> requested, int maxDataOpcodes, int maxControlOpcodes, int maxReservedBits) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (String rExt : requested) {
            QuotedStringTokenizer tok = new QuotedStringTokenizer(rExt, ";");
            String extName = tok.nextToken().trim();
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (tok.hasMoreTokens()) {
                QuotedStringTokenizer nv = new QuotedStringTokenizer(tok.nextToken().trim(), "=");
                String name = nv.nextToken().trim();
                String value = nv.hasMoreTokens() ? nv.nextToken().trim() : null;
                parameters.put(name, value);
            }
            Extension extension = this.newExtension(extName);
            if (extension == null || !extension.init(parameters)) continue;
            Log.debug((String)"add {} {}", (Object)extName, parameters);
            extensions.add(extension);
        }
        Log.debug((String)"extensions={}", extensions);
        return extensions;
    }

    private Extension newExtension(String name) {
        try {
            Class<? extends Extension> extClass = this._extensionClasses.get(name);
            if (extClass != null) {
                return extClass.newInstance();
            }
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
        }
        return null;
    }

    public static interface Acceptor {
        public WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);

        public boolean checkOrigin(HttpServletRequest var1, String var2);
    }
}

