/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Callback;

public abstract class IteratingCallback
implements Callback {
    final AtomicBoolean _iterating = new AtomicBoolean();
    final Callback _callback;

    public IteratingCallback(Callback callback) {
        this._callback = callback;
    }

    protected abstract boolean process() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate() {
        try {
            while (this._iterating.compareAndSet(false, true)) {
                if (!this.process()) continue;
                this._callback.succeeded();
                return;
            }
        }
        catch (Exception e) {
            this._iterating.set(false);
            this._callback.failed(e);
        }
        finally {
            this._iterating.set(false);
        }
    }

    @Override
    public void succeeded() {
        if (!this._iterating.compareAndSet(true, false)) {
            this.iterate();
        }
    }

    @Override
    public void failed(Throwable x) {
        this._callback.failed(x);
    }
}

