/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.LazyList;

public abstract class AbstractHandlerContainer
extends AbstractHandler
implements HandlerContainer {
    @Override
    public Handler[] getChildHandlers() {
        Object list = this.expandChildren(null, null);
        return (Handler[])LazyList.toArray((Object)list, Handler.class);
    }

    @Override
    public Handler[] getChildHandlersByClass(Class<?> byclass) {
        Object list = this.expandChildren(null, byclass);
        return (Handler[])LazyList.toArray((Object)list, byclass);
    }

    @Override
    public <T extends Handler> T getChildHandlerByClass(Class<T> byclass) {
        Object list = this.expandChildren(null, byclass);
        if (list == null) {
            return null;
        }
        return (T)((Handler)LazyList.get((Object)list, (int)0));
    }

    protected Object expandChildren(Object list, Class<?> byClass) {
        return list;
    }

    protected Object expandHandler(Handler handler, Object list, Class<Handler> byClass) {
        if (handler == null) {
            return list;
        }
        if (byClass == null || byClass.isAssignableFrom(handler.getClass())) {
            list = LazyList.add((Object)list, (Object)handler);
        }
        if (handler instanceof AbstractHandlerContainer) {
            list = ((AbstractHandlerContainer)handler).expandChildren(list, byClass);
        } else if (handler instanceof HandlerContainer) {
            HandlerContainer container = (HandlerContainer)((Object)handler);
            Object[] handlers = byClass == null ? container.getChildHandlers() : container.getChildHandlersByClass(byClass);
            list = LazyList.addArray((Object)list, (Object[])handlers);
        }
        return list;
    }

    @Override
    protected void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        this.dumpHandlers(out, indent);
    }

    protected void dumpHandlers(Appendable out, String indent) throws IOException {
        Handler[] handlers = this.getHandlers();
        if (handlers != null) {
            int last = handlers.length - 1;
            for (int h = 0; h <= last; ++h) {
                if (handlers[h] == null) continue;
                out.append(indent);
                out.append(" +-");
                if (handlers[h] instanceof AbstractHandler) {
                    ((AbstractHandler)handlers[h]).dump(out, indent + (h == last ? "   " : " | "));
                    continue;
                }
                out.append(String.valueOf(handlers[h]));
                out.append("\n");
            }
        }
    }
}

