/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.util.log.Log;

public class BlockingChannelConnector
extends AbstractNIOConnector {
    private transient ServerSocketChannel _acceptChannel;

    @Override
    public Object getConnection() {
        return this._acceptChannel;
    }

    @Override
    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
    }

    @Override
    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    @Override
    public void accept(int acceptorID) throws IOException, InterruptedException {
        SocketChannel channel = this._acceptChannel.accept();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        this.configure(socket);
        ConnectorEndPoint connection = new ConnectorEndPoint(channel);
        connection.dispatch();
    }

    @Override
    public void customize(EndPoint endpoint, Request request) throws IOException {
        ConnectorEndPoint connection = (ConnectorEndPoint)endpoint;
        if (connection._sotimeout != this._maxIdleTime) {
            connection._sotimeout = this._maxIdleTime;
            ((SocketChannel)endpoint.getTransport()).socket().setSoTimeout(this._maxIdleTime);
        }
        super.customize(endpoint, request);
        this.configure(((SocketChannel)endpoint.getTransport()).socket());
    }

    @Override
    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    private class ConnectorEndPoint
    extends ChannelEndPoint
    implements Runnable,
    ConnectedEndPoint {
        Connection _connection;
        boolean _dispatched;
        int _sotimeout;

        ConnectorEndPoint(ByteChannel channel) {
            super(channel);
            this._dispatched = false;
            this._connection = new HttpConnection(BlockingChannelConnector.this, (EndPoint)this, BlockingChannelConnector.this.getServer());
        }

        public Connection getConnection() {
            return this._connection;
        }

        public void setConnection(Connection connection) {
            this._connection = connection;
        }

        void dispatch() throws IOException {
            if (!BlockingChannelConnector.this.getThreadPool().dispatch((Runnable)this)) {
                Log.warn((String)"dispatch failed for  {}", (Object)this._connection);
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BlockingChannelConnector.this.connectionOpened(this._connection);
                while (this.isOpen()) {
                    int lrmit;
                    if (this._connection.isIdle() && BlockingChannelConnector.this.getServer().getThreadPool().isLowOnThreads() && (lrmit = BlockingChannelConnector.this.getLowResourcesMaxIdleTime()) >= 0 && this._sotimeout != lrmit) {
                        this._sotimeout = lrmit;
                        ((SocketChannel)this.getTransport()).socket().setSoTimeout(this._sotimeout);
                    }
                    this._connection = this._connection.handle();
                }
            }
            catch (EofException e) {
                Log.debug((String)"EOF", (Object)((Object)e));
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            catch (HttpException e) {
                Log.debug((String)"BAD", (Object)((Object)e));
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            catch (Throwable e) {
                Log.warn((String)"handle failed", (Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            finally {
                BlockingChannelConnector.this.connectionClosed(this._connection);
            }
        }
    }
}

