/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class Dispatcher
implements RequestDispatcher {
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    public static final String __JSP_FILE = "org.apache.catalina.jsp_file";
    private final ContextHandler _contextHandler;
    private final String _uri;
    private final String _path;
    private final String _dQuery;
    private final String _named;

    public Dispatcher(ContextHandler contextHandler, String uri, String pathInContext, String query) {
        this._contextHandler = contextHandler;
        this._uri = uri;
        this._path = pathInContext;
        this._dQuery = query;
        this._named = null;
    }

    public Dispatcher(ContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._named = name;
        this._uri = null;
        this._path = null;
        this._dQuery = null;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.FORWARD);
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        request.removeAttribute(__JSP_FILE);
        DispatcherType old_type = baseRequest.getDispatcherType();
        Attributes old_attr = baseRequest.getAttributes();
        MultiMap old_params = baseRequest.getParameters();
        try {
            baseRequest.setDispatcherType(DispatcherType.INCLUDE);
            baseRequest.getConnection().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    if (old_params == null) {
                        baseRequest.extractParameters();
                        old_params = baseRequest.getParameters();
                    }
                    MultiMap parameters = new MultiMap();
                    UrlEncoded.decodeTo((String)query, (MultiMap)parameters, (String)request.getCharacterEncoding());
                    if (old_params != null && old_params.size() > 0) {
                        for (Map.Entry entry : old_params.entrySet()) {
                            String name = (String)entry.getKey();
                            Object values = entry.getValue();
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add((Object)name, LazyList.get(values, (int)i));
                            }
                        }
                    }
                    baseRequest.setParameters(parameters);
                }
                IncludeAttributes attr = new IncludeAttributes(old_attr);
                attr._requestURI = this._uri;
                attr._contextPath = this._contextHandler.getContextPath();
                attr._servletPath = null;
                attr._pathInfo = this._path;
                attr._query = query;
                baseRequest.setAttributes(attr);
                this._contextHandler.handle(this._path, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        finally {
            baseRequest.setAttributes(old_attr);
            baseRequest.getConnection().included();
            baseRequest.setParameters(old_params);
            baseRequest.setDispatcherType(old_type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest request, ServletResponse response, DispatcherType dispatch) throws ServletException, IOException {
        Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        Response base_response = baseRequest.getResponse();
        response.resetBuffer();
        base_response.fwdReset();
        request.removeAttribute(__JSP_FILE);
        String old_uri = baseRequest.getRequestURI();
        String old_context_path = baseRequest.getContextPath();
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        String old_query = baseRequest.getQueryString();
        Attributes old_attr = baseRequest.getAttributes();
        DispatcherType old_type = baseRequest.getDispatcherType();
        MultiMap old_params = baseRequest.getParameters();
        try {
            baseRequest.setDispatcherType(dispatch);
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    if (old_params == null) {
                        baseRequest.extractParameters();
                        old_params = baseRequest.getParameters();
                    }
                    MultiMap parameters = new MultiMap();
                    UrlEncoded.decodeTo((String)query, (MultiMap)parameters, (String)request.getCharacterEncoding());
                    boolean merge_old_query = false;
                    if (old_params == null) {
                        baseRequest.getParameterNames();
                        old_params = baseRequest.getParameters();
                    }
                    if (old_params != null && old_params.size() > 0) {
                        for (Map.Entry entry : old_params.entrySet()) {
                            String name = (String)entry.getKey();
                            if (parameters.containsKey((Object)name)) {
                                merge_old_query = true;
                            }
                            Object values = entry.getValue();
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add((Object)name, LazyList.get(values, (int)i));
                            }
                        }
                    }
                    if (old_query != null && old_query.length() > 0) {
                        if (merge_old_query) {
                            StringBuilder overridden_query_string = new StringBuilder();
                            MultiMap overridden_old_query = new MultiMap();
                            UrlEncoded.decodeTo((String)old_query, (MultiMap)overridden_old_query, (String)request.getCharacterEncoding());
                            MultiMap overridden_new_query = new MultiMap();
                            UrlEncoded.decodeTo((String)query, (MultiMap)overridden_new_query, (String)request.getCharacterEncoding());
                            for (Map.Entry entry : overridden_old_query.entrySet()) {
                                String name = (String)entry.getKey();
                                if (overridden_new_query.containsKey((Object)name)) continue;
                                Object values = entry.getValue();
                                for (int i = 0; i < LazyList.size(values); ++i) {
                                    overridden_query_string.append("&").append(name).append("=").append(LazyList.get(values, (int)i));
                                }
                            }
                            query = query + overridden_query_string;
                        } else {
                            query = query + "&" + old_query;
                        }
                    }
                    baseRequest.setParameters(parameters);
                    baseRequest.setQueryString(query);
                }
                ForwardAttributes attr = new ForwardAttributes(old_attr);
                if (old_attr.getAttribute("javax.servlet.forward.request_uri") != null) {
                    attr._pathInfo = (String)old_attr.getAttribute("javax.servlet.forward.path_info");
                    attr._query = (String)old_attr.getAttribute("javax.servlet.forward.query_string");
                    attr._requestURI = (String)old_attr.getAttribute("javax.servlet.forward.request_uri");
                    attr._contextPath = (String)old_attr.getAttribute("javax.servlet.forward.context_path");
                    attr._servletPath = (String)old_attr.getAttribute("javax.servlet.forward.servlet_path");
                } else {
                    attr._pathInfo = old_path_info;
                    attr._query = old_query;
                    attr._requestURI = old_uri;
                    attr._contextPath = old_context_path;
                    attr._servletPath = old_servlet_path;
                }
                baseRequest.setRequestURI(this._uri);
                baseRequest.setContextPath(this._contextHandler.getContextPath());
                baseRequest.setAttributes(attr);
                baseRequest.setQueryString(query);
                this._contextHandler.handle(this._path, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
                if (baseRequest.getConnection().getResponse().isWriting()) {
                    try {
                        response.getWriter().close();
                    }
                    catch (IllegalStateException e) {
                        response.getOutputStream().close();
                    }
                } else {
                    try {
                        response.getOutputStream().close();
                    }
                    catch (IllegalStateException e) {
                        response.getWriter().close();
                    }
                }
            }
        }
        finally {
            baseRequest.setRequestURI(old_uri);
            baseRequest.setContextPath(old_context_path);
            baseRequest.setServletPath(old_servlet_path);
            baseRequest.setPathInfo(old_path_info);
            baseRequest.setAttributes(old_attr);
            baseRequest.setParameters(old_params);
            baseRequest.setQueryString(old_query);
            baseRequest.setDispatcherType(old_type);
        }
    }

    private class IncludeAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        IncludeAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals("javax.servlet.include.path_info")) {
                    return this._pathInfo;
                }
                if (key.equals("javax.servlet.include.servlet_path")) {
                    return this._servletPath;
                }
                if (key.equals("javax.servlet.include.context_path")) {
                    return this._contextPath;
                }
                if (key.equals("javax.servlet.include.query_string")) {
                    return this._query;
                }
                if (key.equals("javax.servlet.include.request_uri")) {
                    return this._requestURI;
                }
            } else if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add("javax.servlet.include.path_info");
                } else {
                    set.remove("javax.servlet.include.path_info");
                }
                set.add("javax.servlet.include.request_uri");
                set.add("javax.servlet.include.servlet_path");
                set.add("javax.servlet.include.context_path");
                if (this._query != null) {
                    set.add("javax.servlet.include.query_string");
                } else {
                    set.remove("javax.servlet.include.query_string");
                }
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals("javax.servlet.include.path_info")) {
                    this._pathInfo = (String)value;
                } else if (key.equals("javax.servlet.include.request_uri")) {
                    this._requestURI = (String)value;
                } else if (key.equals("javax.servlet.include.servlet_path")) {
                    this._servletPath = (String)value;
                } else if (key.equals("javax.servlet.include.context_path")) {
                    this._contextPath = (String)value;
                } else if (key.equals("javax.servlet.include.query_string")) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals("javax.servlet.forward.path_info")) {
                    return this._pathInfo;
                }
                if (key.equals("javax.servlet.forward.request_uri")) {
                    return this._requestURI;
                }
                if (key.equals("javax.servlet.forward.servlet_path")) {
                    return this._servletPath;
                }
                if (key.equals("javax.servlet.forward.context_path")) {
                    return this._contextPath;
                }
                if (key.equals("javax.servlet.forward.query_string")) {
                    return this._query;
                }
            }
            if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX) || name.startsWith(Dispatcher.__FORWARD_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add("javax.servlet.forward.path_info");
                } else {
                    set.remove("javax.servlet.forward.path_info");
                }
                set.add("javax.servlet.forward.request_uri");
                set.add("javax.servlet.forward.servlet_path");
                set.add("javax.servlet.forward.context_path");
                if (this._query != null) {
                    set.add("javax.servlet.forward.query_string");
                } else {
                    set.remove("javax.servlet.forward.query_string");
                }
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals("javax.servlet.forward.path_info")) {
                    this._pathInfo = (String)value;
                } else if (key.equals("javax.servlet.forward.request_uri")) {
                    this._requestURI = (String)value;
                } else if (key.equals("javax.servlet.forward.servlet_path")) {
                    this._servletPath = (String)value;
                } else if (key.equals("javax.servlet.forward.context_path")) {
                    this._contextPath = (String)value;
                } else if (key.equals("javax.servlet.forward.query_string")) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }
}

