/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.maven.plugin.JettyRunMojo;
import org.eclipse.jetty.maven.plugin.PluginLog;
import org.eclipse.jetty.maven.plugin.ServerSupport;
import org.eclipse.jetty.maven.plugin.Starter;
import org.eclipse.jetty.maven.plugin.WebAppPropertyConverter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

@Mojo(name="run-forked", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class JettyRunForkedMojo
extends JettyRunMojo {
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File target;
    @Parameter(defaultValue="${project.build.directory}/fork-web.xml")
    protected File forkWebXml;
    @Parameter(property="jetty.jvmArgs")
    private String jvmArgs;
    @Parameter
    private String[] jettyProperties;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="true")
    private boolean waitForChild;
    @Parameter(alias="maxStartupLines", defaultValue="50")
    private int maxChildChecks;
    @Parameter(defaultValue="100")
    private long maxChildCheckInterval;
    @Parameter
    private Map<String, String> env = new HashMap<String, String>();
    private Process forkedProcess;
    private Random random;
    private boolean hasSlf4jDeps;
    @Parameter(property="jetty.javaPath")
    private String javaPath;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        this.random = new Random();
        List deps = this.plugin.getPlugin().getDependencies();
        for (Dependency d : deps) {
            if (!d.getGroupId().contains("slf4j")) continue;
            this.hasSlf4jDeps = true;
            break;
        }
        super.execute();
    }

    @Override
    public void startJetty() throws MojoExecutionException {
        try {
            String classPath;
            this.printSystemProperties();
            if (this.server == null) {
                this.server = new Server();
            }
            ServerSupport.configureHandlers(this.server, null);
            ServerSupport.configureDefaultConfigurationClasses(this.server);
            this.configureWebApplication();
            this.webApp.setCopyWebDir(false);
            this.webApp.setCopyWebInf(false);
            this.webApp.setGenerateQuickStart(true);
            if (this.webApp.getQuickStartWebDescriptor() == null) {
                if (this.forkWebXml == null) {
                    this.forkWebXml = new File(this.target, "fork-web.xml");
                }
                if (!this.forkWebXml.getParentFile().exists()) {
                    this.forkWebXml.getParentFile().mkdirs();
                }
                if (!this.forkWebXml.exists()) {
                    this.forkWebXml.createNewFile();
                }
                this.webApp.setQuickStartWebDescriptor(Resource.newResource((File)this.forkWebXml));
            }
            ServerSupport.addWebApplication(this.server, this.webApp);
            QueuedThreadPool tpool = (QueuedThreadPool)this.server.getBean(QueuedThreadPool.class);
            if (tpool != null) {
                tpool.start();
            } else {
                this.webApp.setAttribute("org.eclipse.jetty.annotations.multiThreaded", Boolean.FALSE.toString());
            }
            this.webApp.setPersistTempDirectory(true);
            this.webApp.start();
            File props = this.prepareConfiguration();
            this.webApp.stop();
            if (tpool != null) {
                tpool.stop();
            }
            ArrayList<String> cmd = new ArrayList<String>();
            if (StringUtil.isNotBlank((String)this.javaPath)) {
                cmd.add(this.javaPath);
            } else {
                cmd.add(this.getJavaBin());
            }
            if (this.jvmArgs != null) {
                String[] args = this.jvmArgs.split(" ");
                for (int i = 0; args != null && i < args.length; ++i) {
                    if (args[i] == null || "".equals(args[i])) continue;
                    cmd.add(args[i].trim());
                }
            }
            if ((classPath = this.getContainerClassPath()) != null && classPath.length() > 0) {
                cmd.add("-cp");
                cmd.add(classPath);
            }
            cmd.add(Starter.class.getCanonicalName());
            if (this.stopPort > 0 && this.stopKey != null) {
                cmd.add("--stop-port");
                cmd.add(Integer.toString(this.stopPort));
                cmd.add("--stop-key");
                cmd.add(this.stopKey);
            }
            if (this.jettyXml != null) {
                cmd.add("--jetty-xml");
                cmd.add(this.jettyXml);
            }
            cmd.add("--props");
            cmd.add(props.getAbsolutePath());
            Path tokenFile = this.target.toPath().resolve(this.createToken() + ".txt");
            cmd.add("--token");
            cmd.add(tokenFile.toAbsolutePath().toString());
            if (this.jettyProperties != null) {
                for (String jettyProp : this.jettyProperties) {
                    cmd.add(jettyProp);
                }
            }
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.directory(this.project.getBasedir());
            if (PluginLog.getLog().isDebugEnabled()) {
                PluginLog.getLog().debug((CharSequence)("Forked cli:" + Arrays.toString(cmd.toArray())));
            }
            PluginLog.getLog().info((CharSequence)"Forked process starting");
            if (!this.env.isEmpty()) {
                builder.environment().putAll(this.env);
            }
            if (this.waitForChild) {
                builder.inheritIO();
            } else {
                builder.redirectOutput(new File(this.target, "jetty.out"));
                builder.redirectErrorStream(true);
            }
            this.forkedProcess = builder.start();
            if (this.waitForChild) {
                int exitcode = this.forkedProcess.waitFor();
                PluginLog.getLog().info((CharSequence)("Forked execution exit: " + exitcode));
            } else {
                int attempts;
                for (attempts = this.maxChildChecks; !Files.exists(tokenFile, new LinkOption[0]) && attempts > 0; --attempts) {
                    Thread.currentThread();
                    Thread.sleep(this.maxChildCheckInterval);
                }
                if (attempts <= 0) {
                    this.getLog().info((CharSequence)"Couldn't verify success of child startup");
                }
            }
        }
        catch (InterruptedException ex) {
            if (this.forkedProcess != null && this.waitForChild) {
                this.forkedProcess.destroy();
            }
            throw new MojoExecutionException("Failed to start Jetty within time limit");
        }
        catch (Exception ex) {
            if (this.forkedProcess != null && this.waitForChild) {
                this.forkedProcess.destroy();
            }
            throw new MojoExecutionException("Failed to create Jetty process", ex);
        }
    }

    public List<String> getProvidedJars() throws MojoExecutionException {
        if (this.useProvidedScope) {
            ArrayList<String> provided = new ArrayList<String>();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!"provided".equals(artifact.getScope()) || this.isPluginArtifact(artifact)) continue;
                provided.add(artifact.getFile().getAbsolutePath());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding provided artifact: " + artifact));
            }
            return provided;
        }
        return null;
    }

    public File prepareConfiguration() throws MojoExecutionException {
        try {
            File propsFile = new File(this.target, "fork.props");
            WebAppPropertyConverter.toProperties(this.webApp, propsFile, this.contextXml);
            return propsFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Prepare webapp configuration", e);
        }
    }

    @Override
    public boolean isPluginArtifact(Artifact artifact) {
        if (this.pluginArtifacts == null || this.pluginArtifacts.isEmpty()) {
            return false;
        }
        for (Artifact pluginArtifact : this.pluginArtifacts) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking " + pluginArtifact));
            }
            if (!pluginArtifact.getGroupId().equals(artifact.getGroupId()) || !pluginArtifact.getArtifactId().equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private Set<Artifact> getExtraJars() throws Exception {
        HashSet<Artifact> extraJars = new HashSet<Artifact>();
        List<Artifact> l = this.pluginArtifacts;
        Object pluginArtifact = null;
        if (l != null) {
            Iterator<Artifact> itor = l.iterator();
            while (itor.hasNext() && pluginArtifact == null) {
                Artifact a = itor.next();
                if (!a.getArtifactId().equals(this.plugin.getArtifactId())) continue;
                extraJars.add(a);
            }
        }
        return extraJars;
    }

    public String getContainerClassPath() throws Exception {
        StringBuilder classPath = new StringBuilder();
        for (Artifact artifact : this.pluginArtifacts) {
            if (!"jar".equals(artifact.getType()) || artifact.getGroupId().contains("slf4j") && !this.hasSlf4jDeps) continue;
            if (classPath.length() > 0) {
                classPath.append(File.pathSeparator);
            }
            classPath.append(artifact.getFile().getAbsolutePath());
        }
        Set<Artifact> extraJars = this.getExtraJars();
        for (Artifact a : extraJars) {
            classPath.append(File.pathSeparator);
            classPath.append(a.getFile().getAbsolutePath());
        }
        List<String> list = this.getProvidedJars();
        if (list != null && !list.isEmpty()) {
            for (String jar : list) {
                classPath.append(File.pathSeparator);
                classPath.append(jar);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding provided jar: " + jar));
            }
        }
        return classPath.toString();
    }

    public static String pathSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == ',' || c == ':') {
                ret.append(File.pathSeparatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private String createToken() {
        return Long.toString(this.random.nextLong() ^ System.currentTimeMillis(), 36).toUpperCase(Locale.ENGLISH);
    }

    public class ShutdownThread
    extends Thread {
        public ShutdownThread() {
            super("RunForkedShutdown");
        }

        @Override
        public void run() {
            if (JettyRunForkedMojo.this.forkedProcess != null && JettyRunForkedMojo.this.waitForChild) {
                JettyRunForkedMojo.this.forkedProcess.destroy();
            }
        }
    }
}

