/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyServer
extends Server {
    public static final JettyServer __instance = new JettyServer();
    private RequestLog requestLog;
    private ContextHandlerCollection contexts;

    public static JettyServer getInstance() {
        return __instance;
    }

    private JettyServer() {
        this.setStopAtShutdown(true);
        Resource.setDefaultUseCaches((boolean)false);
    }

    public void setRequestLog(RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void addWebApplication(WebAppContext webapp) throws Exception {
        this.contexts.addHandler((Handler)webapp);
    }

    public void configureHandlers() throws Exception {
        DefaultHandler defaultHandler = new DefaultHandler();
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        if (this.requestLog != null) {
            requestLogHandler.setRequestLog(this.requestLog);
        }
        this.contexts = (ContextHandlerCollection)super.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this.contexts == null) {
            this.contexts = new ContextHandlerCollection();
            HandlerCollection handlers = (HandlerCollection)super.getChildHandlerByClass(HandlerCollection.class);
            if (handlers == null) {
                handlers = new HandlerCollection();
                super.setHandler((Handler)handlers);
                handlers.setHandlers(new Handler[]{this.contexts, defaultHandler, requestLogHandler});
            } else {
                handlers.addHandler((Handler)this.contexts);
            }
        }
    }
}

