/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.annotation.MultipartConfig;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class MultiPartConfigAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _wac;

    public MultiPartConfigAnnotationHandler(WebAppContext context) {
        super(false);
        this._wac = context;
    }

    @Override
    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        MultipartConfig multi = clazz.getAnnotation(MultipartConfig.class);
        if (multi == null) {
            return;
        }
        ServletHolder[] holders = this._wac.getServletHandler().getServlets();
        if (holders != null) {
            for (ServletHolder h : holders) {
                if (!h.getClassName().equals(clazz.getName())) continue;
                h.getRegistration().setMultipartConfig(new MultipartConfigElement(multi));
            }
        }
    }
}

