/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui.property_editor;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class IntField
extends JTextField {
    private NumberFormat integer_formatter_ = NumberFormat.getNumberInstance();

    public IntField() {
        this.integer_formatter_.setParseIntegerOnly(true);
    }

    public int getValue() {
        int ret_val = 0;
        try {
            ret_val = this.integer_formatter_.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret_val;
    }

    public void setValue(int value) {
        this.setText(this.integer_formatter_.format(value));
    }

    protected Document createDefaultModel() {
        return new IntDocument();
    }

    protected class IntDocument
    extends PlainDocument {
        protected IntDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String curVal = this.getText(0, this.getLength());
            char[] buffer = str.toCharArray();
            char[] digit = new char[buffer.length];
            int j = 0;
            if (offs == 0 && buffer != null && buffer.length > 0 && buffer[0] == '-') {
                digit[j++] = buffer[0];
            }
            for (int i = 0; i < buffer.length; ++i) {
                if (!Character.isDigit(buffer[i])) continue;
                digit[j++] = buffer[i];
            }
            String added = new String(digit, 0, j);
            try {
                StringBuffer val = new StringBuffer(curVal);
                val.insert(offs, added);
                if (val.toString().equals("-")) {
                    super.insertString(offs, added, a);
                } else {
                    Integer.valueOf(val.toString());
                    super.insertString(offs, added, a);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

