/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui;

import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.dinopolis.util.Resources;
import org.dinopolis.util.gui.ActionGenerator;
import org.dinopolis.util.gui.MenuButtonActionChangedListener;
import org.dinopolis.util.gui.MenuItemActionChangedListener;

public class MenuFactory {
    public static final String SELECTED = "selected";
    public static final String KEY_MENUES = "menu";
    public static final String KEY_MENUE_PREFIX = "menu.";
    public static final String KEY_RESOURCE_LABEL_SUFFIX = ".label";
    public static final String KEY_RESOURCE_ICON_SUFFIX = ".icon";
    public static final String KEY_RESOURCE_ACTION_SUFFIX = ".action";
    public static final String KEY_RESOURCE_TYPE_SUFFIX = ".type";
    public static final String KEY_CONTEXT_MENU_PREFIX = "contextmenu.";
    public static final String BOX_IDENTIFIER = "|";
    public static final String SEPARATOR_IDENTIFIER = "-";
    public static final String OR_SEPERATOR = "|";
    public static final String KEY_RESOURCE_ACCELERATOR_SUFFIX = ".accelerator";
    public static final String KEY_RESOURCE_MNEMONIC_SUFFIX = ".mnemonic";
    public static final String TYPE_MENU = "menu";
    public static final String TYPE_EMPTY_MENU = "empty_menu";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_CHECK = "check";
    public static final String TYPE_ITEM = "item";

    public static JMenuBar createMenuBar(Resources resources, ActionGenerator action_gen) {
        JMenuBar menu_bar = new JMenuBar();
        String[] menues = resources.getStringArray("menu", " ");
        for (int count = 0; count < menues.length; ++count) {
            if (menues[count].equals("|")) {
                if (!(menu_bar.getLayout() instanceof BoxLayout)) continue;
                menu_bar.add(Box.createHorizontalGlue());
                continue;
            }
            menu_bar.add(MenuFactory.createMenu(KEY_MENUE_PREFIX, menues[count], resources, action_gen));
        }
        return menu_bar;
    }

    public static JMenu createMenu(String prefix, String menu_name, Resources resources, ActionGenerator action_gen) {
        String type = resources.getString(prefix + menu_name + KEY_RESOURCE_TYPE_SUFFIX, "");
        if (TYPE_EMPTY_MENU.equalsIgnoreCase(type)) {
            JMenu menu = new JMenu();
            MenuFactory.initializeMenu(menu, prefix, menu_name, resources);
            return menu;
        }
        String[] item_keys = resources.getStringArray(prefix + menu_name, " ,");
        if (item_keys.length < 1) {
            return null;
        }
        JMenu menu = new JMenu();
        MenuFactory.initializeMenu(menu, prefix, menu_name, resources);
        for (int count = 0; count < item_keys.length; ++count) {
            JComponent comp = MenuFactory.createMenuComponent(prefix, item_keys[count], resources, action_gen);
            if (comp == null) continue;
            menu.add(comp);
        }
        return menu;
    }

    public static JPopupMenu createPopupMenu(String prefix, String menu_string, Resources resources, ActionGenerator action_gen) {
        StringTokenizer tok = new StringTokenizer(menu_string);
        JPopupMenu popup_menu = new JPopupMenu();
        while (tok.hasMoreTokens()) {
            String menu_item_string = tok.nextToken();
            popup_menu.add(MenuFactory.createMenuComponent(prefix, menu_item_string, resources, action_gen));
        }
        return popup_menu;
    }

    public static JPopupMenu createPopupMenu(String menu_string, Resources resources, ActionGenerator action_gen) {
        return MenuFactory.createPopupMenu(KEY_CONTEXT_MENU_PREFIX, menu_string, resources, action_gen);
    }

    public static JComponent createMenuComponent(String prefix, String menu_name, Resources resources, ActionGenerator action_gen) {
        if (menu_name.trim().equals(SEPARATOR_IDENTIFIER)) {
            return new JSeparator();
        }
        String type = resources.getString(prefix + menu_name + KEY_RESOURCE_TYPE_SUFFIX, TYPE_ITEM);
        if (type.equalsIgnoreCase("menu")) {
            return MenuFactory.createMenu(prefix, menu_name, resources, action_gen);
        }
        if (type.equalsIgnoreCase(TYPE_RADIO)) {
            return MenuFactory.createRadioButtonMenuItem(prefix, menu_name, resources, action_gen);
        }
        if (type.equalsIgnoreCase(TYPE_CHECK)) {
            return MenuFactory.createCheckBoxMenuItem(prefix, menu_name, resources, action_gen);
        }
        if (type.equalsIgnoreCase(TYPE_EMPTY_MENU)) {
            JMenu menu = new JMenu();
            MenuFactory.initializeMenu(menu, prefix, menu_name, resources);
            return menu;
        }
        return MenuFactory.createMenuItem(prefix, menu_name, resources, action_gen);
    }

    public static JComponent createMenuItem(String prefix, String menu_names, Resources resources, ActionGenerator action_gen) {
        StringTokenizer tok = new StringTokenizer(menu_names, "|");
        JMenuItem menu_item = new JMenuItem();
        MenuItemActionChangedListener action_listener = new MenuItemActionChangedListener(menu_item);
        Action action_to_set = null;
        Action action = null;
        while (tok.hasMoreTokens()) {
            String menu_name = tok.nextToken();
            action = MenuFactory.initializeMenuItem(menu_item, prefix, menu_name, resources, action_gen);
            if (action != null) {
                if (action_to_set == null || action.isEnabled()) {
                    action_to_set = action;
                }
                action.addPropertyChangeListener(action_listener);
                continue;
            }
            System.err.println("WARNING: MenuFactory.createMenuItem: action for '" + prefix + menu_name + "' with name '" + resources.getString(prefix + menu_names + KEY_RESOURCE_ACTION_SUFFIX, "") + "' not found in action generator.");
        }
        if (action_to_set != null) {
            action_listener.setSelected(action_to_set);
        }
        return menu_item;
    }

    public static JComponent createRadioButtonMenuItem(String prefix, String menu_name, Resources resources, ActionGenerator action_gen) {
        JRadioButtonMenuItem radio_menu_item = new JRadioButtonMenuItem();
        Action action = MenuFactory.initializeMenuItem(radio_menu_item, prefix, menu_name, resources, action_gen);
        if (action != null) {
            MenuButtonActionChangedListener action_listener = new MenuButtonActionChangedListener(radio_menu_item);
            action.addPropertyChangeListener(action_listener);
            Object selected = action.getValue(SELECTED);
            if (selected != null && selected instanceof Boolean) {
                radio_menu_item.setSelected((Boolean)selected);
            }
        } else {
            System.err.println("WARNING: MenuFactory.createRadioButtonMenuItem: action for '" + prefix + menu_name + "' with name '" + resources.getString(prefix + menu_name + KEY_RESOURCE_ACTION_SUFFIX, menu_name) + "' not found in action generator.");
        }
        return radio_menu_item;
    }

    public static JComponent createCheckBoxMenuItem(String prefix, String menu_name, Resources resources, ActionGenerator action_gen) {
        JCheckBoxMenuItem checkbox_menu_item = new JCheckBoxMenuItem();
        Action action = MenuFactory.initializeMenuItem(checkbox_menu_item, prefix, menu_name, resources, action_gen);
        if (action != null) {
            MenuButtonActionChangedListener action_listener = new MenuButtonActionChangedListener(checkbox_menu_item);
            action.addPropertyChangeListener(action_listener);
            Object selected = action.getValue(SELECTED);
            if (selected != null && selected instanceof Boolean) {
                checkbox_menu_item.setSelected((Boolean)selected);
            }
        } else {
            System.err.println("WARNING: MenuFactory.createCheckBoxMenuItem: action for '" + prefix + menu_name + "' with name '" + resources.getString(prefix + menu_name + KEY_RESOURCE_ACTION_SUFFIX, menu_name) + "' not found in action generator.");
        }
        return checkbox_menu_item;
    }

    protected static Action initializeMenuItem(JMenuItem menu_item, String prefix, String menu_name, Resources resources, ActionGenerator action_gen) {
        String action_name = resources.getString(prefix + menu_name + KEY_RESOURCE_ACTION_SUFFIX, menu_name);
        String menu_item_label = resources.getString(prefix + menu_name + KEY_RESOURCE_LABEL_SUFFIX, null);
        Icon menu_item_icon = resources.getIcon(prefix + menu_name + KEY_RESOURCE_ICON_SUFFIX, null);
        if (menu_item_label == null && menu_item_icon == null) {
            menu_item_label = prefix + menu_name;
        }
        menu_item.setText(menu_item_label);
        Action action = action_gen.getAction(action_name);
        if (action != null) {
            String accelerator;
            action.putValue("SmallIcon", menu_item_icon);
            action.putValue("Name", menu_item_label);
            action.putValue("ActionCommandKey", action_name);
            String mnemonic = resources.getString(prefix + menu_name + KEY_RESOURCE_MNEMONIC_SUFFIX, null);
            if (mnemonic != null && mnemonic.length() > 0) {
                action.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
            }
            if ((accelerator = resources.getString(prefix + menu_name + KEY_RESOURCE_ACCELERATOR_SUFFIX, null)) != null) {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelerator));
            }
            menu_item.setAction(action);
        } else {
            menu_item.setEnabled(false);
        }
        return action;
    }

    protected static void initializeMenu(JMenu menu, String prefix, String menu_name, Resources resources) {
        String mnemonic;
        String menu_label = resources.getString(prefix + menu_name + KEY_RESOURCE_LABEL_SUFFIX, null);
        Icon menu_icon = resources.getIcon(prefix + menu_name + KEY_RESOURCE_ICON_SUFFIX, null);
        if (menu_label == null && menu_icon == null) {
            menu_label = prefix + menu_name;
        }
        menu.setText(menu_label);
        if (menu_icon != null) {
            menu.setIcon(menu_icon);
        }
        if ((mnemonic = resources.getString(prefix + menu_name + KEY_RESOURCE_MNEMONIC_SUFFIX, null)) != null && mnemonic.length() > 0) {
            menu.setMnemonic(mnemonic.charAt(0));
        }
    }
}

