/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.FFmpegFrameFilter;
import org.bytedeco.javacv.FrameFilter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"filter", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FilterImageTransform
extends BaseImageTransform {
    private FFmpegFrameFilter filter;
    private String filters;
    private int width;
    private int height;
    private int channels;

    public FilterImageTransform(String filters, int width, int height) {
        this(filters, width, height, 3);
    }

    public FilterImageTransform(@JsonProperty(value="filters") String filters, @JsonProperty(value="width") int width, @JsonProperty(value="height") int height, @JsonProperty(value="channels") int channels) {
        super(null);
        int pixelFormat;
        this.filters = filters;
        this.width = width;
        this.height = height;
        this.channels = channels;
        int n = channels == 1 ? 8 : (channels == 3 ? 3 : (pixelFormat = channels == 4 ? 26 : -1));
        if (pixelFormat == -1) {
            throw new IllegalArgumentException("Unsupported number of channels: " + channels);
        }
        try {
            this.filter = new FFmpegFrameFilter(filters, width, height);
            this.filter.setPixelFormat(pixelFormat);
            this.filter.start();
        }
        catch (FrameFilter.Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        try {
            this.filter.push(image.getFrame());
            image = new ImageWritable(this.filter.pull());
        }
        catch (FrameFilter.Exception e) {
            throw new RuntimeException(e);
        }
        return image;
    }

    public FFmpegFrameFilter getFilter() {
        return this.filter;
    }

    public String getFilters() {
        return this.filters;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setFilter(FFmpegFrameFilter filter) {
        this.filter = filter;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterImageTransform)) {
            return false;
        }
        FilterImageTransform other = (FilterImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getChannels() != other.getChannels()) {
            return false;
        }
        FFmpegFrameFilter this$filter = this.getFilter();
        FFmpegFrameFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        String this$filters = this.getFilters();
        String other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !this$filters.equals(other$filters));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FilterImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getChannels();
        FFmpegFrameFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        String $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FilterImageTransform(filter=" + this.getFilter() + ", filters=" + this.getFilters() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", channels=" + this.getChannels() + ")";
    }
}

