/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource.proxool;

import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DatastoreDriverNotFoundException;
import org.datanucleus.store.rdbms.datasource.DatastorePoolException;
import org.datanucleus.util.ClassUtils;
import org.logicalcobwebs.proxool.ProxoolDataSource;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class ProxoolDataSourceFactory
implements DataNucleusDataSourceFactory {
    private static int poolNumber = 0;

    public DataSource makePooledDataSource(OMFContext omfCtx) {
        String dbPassword;
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        StoreManager storeMgr = omfCtx.getStoreManager();
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        if ((dbPassword = storeMgr.getConnectionPassword()) == null) {
            dbPassword = "";
        }
        ClassLoaderResolver clr = omfCtx.getClassLoaderResolver(null);
        try {
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                clr.classForName(dbDriver);
            }
            catch (RuntimeException e) {
                throw new DatastoreDriverNotFoundException(dbDriver);
            }
        }
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.logging.Log", (String)"commons-logging.jar");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.logicalcobwebs.proxool.ProxoolDriver", (String)"proxool.jar");
        String alias = "datanucleus" + poolNumber;
        try {
            Properties props = new Properties();
            if (conf.hasProperty("datanucleus.connectionPool.maxConnections")) {
                int value = conf.getIntProperty("datanucleus.connectionPool.maxConnections");
                if (value > 0) {
                    ((Hashtable)props).put("proxool.maximum-connection-count", "" + value);
                } else {
                    ((Hashtable)props).put("proxool.maximum-connection-count", "10");
                }
            } else {
                ((Hashtable)props).put("proxool.maximum-connection-count", "10");
            }
            if (conf.hasProperty("datanucleus.connectionPool.testSQL")) {
                String value = conf.getStringProperty("datanucleus.connectionPool.testSQL");
                ((Hashtable)props).put("proxool.house-keeping-test-sql", value);
            } else {
                ((Hashtable)props).put("proxool.house-keeping-test-sql", "SELECT 1");
            }
            props.setProperty("user", dbUser);
            props.setProperty("password", dbPassword);
            String url = "proxool." + alias + ":" + dbDriver + ":" + dbURL;
            ++poolNumber;
            ProxoolFacade.registerConnectionPool((String)url, (Properties)props);
        }
        catch (ProxoolException pe) {
            pe.printStackTrace();
            throw new DatastorePoolException("Proxool", dbDriver, dbURL, (Exception)((Object)pe));
        }
        ProxoolDataSource ds = new ProxoolDataSource(alias);
        return ds;
    }
}

