/**
 * Copyright (C) 2012 cogroo <cogroo@cogroo.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cogroo.exceptions;

public class CogrooRuntimeException extends InternationalizedRuntimeException {

  private static final long serialVersionUID = -6275921375016678991L;

  /**
   * The name of the {@link java.util.ResourceBundle ResourceBundle} containing
   * the standard Cogroo Exception messages.
   */
  public static final String STANDARD_MESSAGE_CATALOG = "CommunityException_Messages";

  /**
   * Creates a new exception with a null message.
   */
  public CogrooRuntimeException() {
    super();
  }

  /**
   * Creates a new exception with the specified cause and a null message.
   * 
   * @param aCause
   *          the original exception that caused this exception to be thrown, if
   *          any
   */
  public CogrooRuntimeException(Throwable aCause) {
    super(aCause);
  }

  /**
   * Creates a new exception with a the specified message.
   * 
   * @param aResourceBundleName
   *          the base name of the resource bundle in which the message for this
   *          exception is located.
   * @param aMessageKey
   *          an identifier that maps to the message for this exception. The
   *          message may contain placeholders for arguments as defined by the
   *          {@link java.text.MessageFormat MessageFormat} class.
   * @param aArguments
   *          The arguments to the message. <code>null</code> may be used if the
   *          message has no arguments.
   */
  public CogrooRuntimeException(String aResourceBundleName, String aMessageKey,
      Object[] aArguments) {
    super(aResourceBundleName, aMessageKey, aArguments);
  }

  /**
   * Creates a new exception with the specified message and cause.
   * 
   * @param aResourceBundleName
   *          the base name of the resource bundle in which the message for this
   *          exception is located.
   * @param aMessageKey
   *          an identifier that maps to the message for this exception. The
   *          message may contain placeholders for arguments as defined by the
   *          {@link java.text.MessageFormat MessageFormat} class.
   * @param aArguments
   *          The arguments to the message. <code>null</code> may be used if the
   *          message has no arguments.
   * @param aCause
   *          the original exception that caused this exception to be thrown, if
   *          any
   */
  public CogrooRuntimeException(String aResourceBundleName, String aMessageKey,
      Object[] aArguments, Throwable aCause) {
    super(aResourceBundleName, aMessageKey, aArguments, aCause);
  }

  /**
   * Creates a new exception with a message from the
   * {@link #STANDARD_MESSAGE_CATALOG}.
   * 
   * @param aMessageKey
   *          an identifier that maps to the message for this exception. The
   *          message may contain placeholders for arguments as defined by the
   *          {@link java.text.MessageFormat MessageFormat} class.
   * @param aArguments
   *          The arguments to the message. <code>null</code> may be used if the
   *          message has no arguments.
   */
  public CogrooRuntimeException(String aMessageKey, Object[] aArguments) {
    super(STANDARD_MESSAGE_CATALOG, aMessageKey, aArguments);
  }

  /**
   * Creates a new exception with the specified cause and a message from the
   * {@link #STANDARD_MESSAGE_CATALOG}.
   * 
   * @param aMessageKey
   *          an identifier that maps to the message for this exception. The
   *          message may contain placeholders for arguments as defined by the
   *          {@link java.text.MessageFormat MessageFormat} class.
   * @param aArguments
   *          The arguments to the message. <code>null</code> may be used if the
   *          message has no arguments.
   * @param aCause
   *          the original exception that caused this exception to be thrown, if
   *          any
   */
  public CogrooRuntimeException(String aMessageKey, Object[] aArguments,
      Throwable aCause) {
    super(STANDARD_MESSAGE_CATALOG, aMessageKey, aArguments, aCause);
  }
}
