/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import com.google.common.base.Charsets;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.ServerComponent;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.profiles.Alert;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.Logs;
import org.sonar.api.utils.ValidationMessages;

public final class XMLProfileParser
implements ServerComponent {
    private final RuleFinder ruleFinder;
    private MetricFinder metricFinder;

    @Deprecated
    public XMLProfileParser(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    @Deprecated
    public XMLProfileParser(RuleFinder ruleFinder, MetricFinder metricFinder) {
        this.ruleFinder = ruleFinder;
        this.metricFinder = metricFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RulesProfile parseResource(ClassLoader classloader, String xmlClassPath, ValidationMessages messages) {
        InputStreamReader reader = new InputStreamReader(classloader.getResourceAsStream(xmlClassPath), Charsets.UTF_8);
        try {
            RulesProfile rulesProfile = this.parse(reader, messages);
            return rulesProfile;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public RulesProfile parse(Reader reader, ValidationMessages messages) {
        RulesProfile profile = RulesProfile.create();
        SMInputFactory inputFactory = this.initStax();
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(reader);
            rootC.advance();
            SMInputCursor cursor = rootC.childElementCursor();
            while (cursor.getNext() != null) {
                String nodeName = cursor.getLocalName();
                if (StringUtils.equals((String)"rules", (String)nodeName)) {
                    SMInputCursor rulesCursor = cursor.childElementCursor("rule");
                    this.processRules(rulesCursor, profile, messages);
                    continue;
                }
                if (StringUtils.equals((String)"alerts", (String)nodeName)) {
                    SMInputCursor alertsCursor = cursor.childElementCursor("alert");
                    this.processAlerts(alertsCursor, profile, messages);
                    continue;
                }
                if (StringUtils.equals((String)"name", (String)nodeName)) {
                    profile.setName(StringUtils.trim((String)cursor.collectDescendantText(false)));
                    continue;
                }
                if (!StringUtils.equals((String)"language", (String)nodeName)) continue;
                profile.setLanguage(StringUtils.trim((String)cursor.collectDescendantText(false)));
            }
        }
        catch (XMLStreamException e) {
            messages.addErrorText("XML is not valid: " + e.getMessage());
        }
        this.checkProfile(profile, messages);
        return profile;
    }

    private void checkProfile(RulesProfile profile, ValidationMessages messages) {
        if (StringUtils.isBlank((String)profile.getName())) {
            messages.addErrorText("The mandatory node <name> is missing.");
        }
        if (StringUtils.isBlank((String)profile.getLanguage())) {
            messages.addErrorText("The mandatory node <language> is missing.");
        }
    }

    private SMInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    private void processRules(SMInputCursor rulesCursor, RulesProfile profile, ValidationMessages messages) throws XMLStreamException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (rulesCursor.getNext() != null) {
            SMInputCursor ruleCursor = rulesCursor.childElementCursor();
            String repositoryKey = null;
            String key = null;
            RulePriority priority = null;
            parameters.clear();
            while (ruleCursor.getNext() != null) {
                String nodeName = ruleCursor.getLocalName();
                if (StringUtils.equals((String)"repositoryKey", (String)nodeName)) {
                    repositoryKey = StringUtils.trim((String)ruleCursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)"key", (String)nodeName)) {
                    key = StringUtils.trim((String)ruleCursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)"priority", (String)nodeName)) {
                    priority = RulePriority.valueOf(StringUtils.trim((String)ruleCursor.collectDescendantText(false)));
                    continue;
                }
                if (!StringUtils.equals((String)"parameters", (String)nodeName)) continue;
                SMInputCursor propsCursor = ruleCursor.childElementCursor("parameter");
                this.processParameters(propsCursor, parameters);
            }
            Rule rule = this.ruleFinder.findByKey(repositoryKey, key);
            if (rule == null) {
                messages.addWarningText("Rule not found: " + this.ruleToString(repositoryKey, key));
                continue;
            }
            ActiveRule activeRule = profile.activateRule(rule, priority);
            for (Map.Entry entry : parameters.entrySet()) {
                if (rule.getParam((String)entry.getKey()) == null) {
                    messages.addWarningText("The parameter '" + (String)entry.getKey() + "' does not exist in the rule: " + this.ruleToString(repositoryKey, key));
                    continue;
                }
                activeRule.setParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private String ruleToString(String repositoryKey, String key) {
        return "[repository=" + repositoryKey + ", key=" + key + "]";
    }

    private void processParameters(SMInputCursor propsCursor, Map<String, String> parameters) throws XMLStreamException {
        while (propsCursor.getNext() != null) {
            SMInputCursor propCursor = propsCursor.childElementCursor();
            String key = null;
            String value = null;
            while (propCursor.getNext() != null) {
                String nodeName = propCursor.getLocalName();
                if (StringUtils.equals((String)"key", (String)nodeName)) {
                    key = StringUtils.trim((String)propCursor.collectDescendantText(false));
                    continue;
                }
                if (!StringUtils.equals((String)"value", (String)nodeName)) continue;
                value = StringUtils.trim((String)propCursor.collectDescendantText(false));
            }
            if (key == null) continue;
            parameters.put(key, value);
        }
    }

    private void processAlerts(SMInputCursor alertsCursor, RulesProfile profile, ValidationMessages messages) throws XMLStreamException {
        if (this.metricFinder == null) {
            Logs.INFO.error("Unable to parse alerts, because MetricFinder not available.");
            return;
        }
        while (alertsCursor.getNext() != null) {
            SMInputCursor alertCursor = alertsCursor.childElementCursor();
            String metricKey = null;
            String operator = "";
            String valueError = "";
            String valueWarning = "";
            Integer period = null;
            while (alertCursor.getNext() != null) {
                String nodeName = alertCursor.getLocalName();
                if (StringUtils.equals((String)"metric", (String)nodeName)) {
                    metricKey = StringUtils.trim((String)alertCursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)"period", (String)nodeName)) {
                    String periodParameter = StringUtils.trim((String)alertCursor.collectDescendantText(false));
                    if (!StringUtils.isNotBlank((String)periodParameter)) continue;
                    period = Integer.parseInt(periodParameter);
                    continue;
                }
                if (StringUtils.equals((String)"operator", (String)nodeName)) {
                    operator = StringUtils.trim((String)alertCursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)"warning", (String)nodeName)) {
                    valueWarning = StringUtils.trim((String)alertCursor.collectDescendantText(false));
                    continue;
                }
                if (!StringUtils.equals((String)"error", (String)nodeName)) continue;
                valueError = StringUtils.trim((String)alertCursor.collectDescendantText(false));
            }
            Metric metric = this.metricFinder.findByKey(metricKey);
            if (metric == null) {
                messages.addWarningText("Metric '" + metricKey + "' does not exist");
                continue;
            }
            Alert alert = new Alert(profile, metric, operator, valueError, valueWarning, period);
            profile.getAlerts().add(alert);
        }
    }
}

