/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.rule.RuleKey;

public class IssueQuery {
    public static final int DEFAULT_PAGE_INDEX = 1;
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final int MAX_RESULTS = 10000;
    public static final int MAX_PAGE_SIZE = 500;
    @Deprecated
    public static final int MAX_ISSUE_KEYS = 500;
    public static final String SORT_BY_CREATION_DATE = "CREATION_DATE";
    public static final String SORT_BY_UPDATE_DATE = "UPDATE_DATE";
    public static final String SORT_BY_CLOSE_DATE = "CLOSE_DATE";
    public static final String SORT_BY_ASSIGNEE = "ASSIGNEE";
    public static final String SORT_BY_SEVERITY = "SEVERITY";
    public static final String SORT_BY_STATUS = "STATUS";
    public static final Set<String> SORTS = ImmutableSet.of((Object)"CREATION_DATE", (Object)"UPDATE_DATE", (Object)"CLOSE_DATE", (Object)"ASSIGNEE", (Object)"SEVERITY", (Object)"STATUS", (Object[])new String[0]);
    private final Collection<String> issueKeys;
    private final Collection<String> severities;
    private final Collection<String> statuses;
    private final Collection<String> resolutions;
    private final Collection<String> components;
    private final Collection<String> componentRoots;
    private final Collection<RuleKey> rules;
    private final Collection<String> actionPlans;
    private final Collection<String> reporters;
    private final Collection<String> assignees;
    private final Boolean assigned;
    private final Boolean planned;
    private final Boolean resolved;
    private final Date createdAt;
    private final Date createdAfter;
    private final Date createdBefore;
    private final String sort;
    private final Boolean asc;
    private final String requiredRole;
    private final int pageSize;
    private final int pageIndex;

    private IssueQuery(Builder builder) {
        this.issueKeys = IssueQuery.defaultCollection(builder.issueKeys);
        this.severities = IssueQuery.defaultCollection(builder.severities);
        this.statuses = IssueQuery.defaultCollection(builder.statuses);
        this.resolutions = IssueQuery.defaultCollection(builder.resolutions);
        this.components = IssueQuery.defaultCollection(builder.components);
        this.componentRoots = IssueQuery.defaultCollection(builder.componentRoots);
        this.rules = IssueQuery.defaultCollection(builder.rules);
        this.actionPlans = IssueQuery.defaultCollection(builder.actionPlans);
        this.reporters = IssueQuery.defaultCollection(builder.reporters);
        this.assignees = IssueQuery.defaultCollection(builder.assignees);
        this.assigned = builder.assigned;
        this.planned = builder.planned;
        this.resolved = builder.resolved;
        this.createdAt = builder.createdAt;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.sort = builder.sort;
        this.asc = builder.asc;
        this.pageSize = builder.pageSize;
        this.pageIndex = builder.pageIndex;
        this.requiredRole = builder.requiredRole;
    }

    public Collection<String> issueKeys() {
        return this.issueKeys;
    }

    public Collection<String> severities() {
        return this.severities;
    }

    public Collection<String> statuses() {
        return this.statuses;
    }

    public Collection<String> resolutions() {
        return this.resolutions;
    }

    public Collection<String> components() {
        return this.components;
    }

    public Collection<String> componentRoots() {
        return this.componentRoots;
    }

    public Collection<RuleKey> rules() {
        return this.rules;
    }

    public Collection<String> actionPlans() {
        return this.actionPlans;
    }

    public Collection<String> reporters() {
        return this.reporters;
    }

    public Collection<String> assignees() {
        return this.assignees;
    }

    @CheckForNull
    public Boolean assigned() {
        return this.assigned;
    }

    @CheckForNull
    public Boolean planned() {
        return this.planned;
    }

    @CheckForNull
    public Boolean resolved() {
        return this.resolved;
    }

    @CheckForNull
    public Date createdAfter() {
        return this.createdAfter == null ? null : new Date(this.createdAfter.getTime());
    }

    @CheckForNull
    public Date createdAt() {
        return this.createdAt == null ? null : new Date(this.createdAt.getTime());
    }

    @CheckForNull
    public Date createdBefore() {
        return this.createdBefore == null ? null : new Date(this.createdBefore.getTime());
    }

    @CheckForNull
    public String sort() {
        return this.sort;
    }

    @CheckForNull
    public Boolean asc() {
        return this.asc;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int pageIndex() {
        return this.pageIndex;
    }

    public int maxResults() {
        return 10000;
    }

    public String requiredRole() {
        return this.requiredRole;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> Collection<T> defaultCollection(@Nullable Collection<T> c) {
        return c == null ? Collections.emptyList() : Collections.unmodifiableCollection(c);
    }

    public static class Builder {
        private Collection<String> issueKeys;
        private Collection<String> severities;
        private Collection<String> statuses;
        private Collection<String> resolutions;
        private Collection<String> components;
        private Collection<String> componentRoots;
        private Collection<RuleKey> rules;
        private Collection<String> actionPlans;
        private Collection<String> reporters;
        private Collection<String> assignees;
        private Boolean assigned = null;
        private Boolean planned = null;
        private Boolean resolved = null;
        private Date createdAt;
        private Date createdAfter;
        private Date createdBefore;
        private String sort;
        private Boolean asc = false;
        private Integer pageSize;
        private Integer pageIndex;
        private String requiredRole = "user";

        private Builder() {
        }

        public Builder issueKeys(@Nullable Collection<String> l) {
            this.issueKeys = l;
            return this;
        }

        public Builder severities(@Nullable Collection<String> l) {
            this.severities = l;
            return this;
        }

        public Builder statuses(@Nullable Collection<String> l) {
            this.statuses = l;
            return this;
        }

        public Builder resolutions(@Nullable Collection<String> l) {
            this.resolutions = l;
            return this;
        }

        public Builder components(@Nullable Collection<String> l) {
            this.components = l;
            return this;
        }

        public Builder componentRoots(@Nullable Collection<String> l) {
            this.componentRoots = l;
            return this;
        }

        public Builder rules(@Nullable Collection<RuleKey> rules) {
            this.rules = rules;
            return this;
        }

        public Builder actionPlans(@Nullable Collection<String> l) {
            this.actionPlans = l;
            return this;
        }

        public Builder reporters(@Nullable Collection<String> l) {
            this.reporters = l;
            return this;
        }

        public Builder assignees(@Nullable Collection<String> l) {
            this.assignees = l;
            return this;
        }

        public Builder assigned(@Nullable Boolean b) {
            this.assigned = b;
            return this;
        }

        public Builder planned(@Nullable Boolean planned) {
            this.planned = planned;
            return this;
        }

        public Builder resolved(@Nullable Boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        public Builder createdAt(@Nullable Date d) {
            this.createdAt = d == null ? null : new Date(d.getTime());
            return this;
        }

        public Builder createdAfter(@Nullable Date d) {
            this.createdAfter = d == null ? null : new Date(d.getTime());
            return this;
        }

        public Builder createdBefore(@Nullable Date d) {
            this.createdBefore = d == null ? null : new Date(d.getTime());
            return this;
        }

        public Builder sort(@Nullable String s) {
            if (s != null && !SORTS.contains(s)) {
                throw new IllegalArgumentException("Bad sort field: " + s);
            }
            this.sort = s;
            return this;
        }

        public Builder asc(@Nullable Boolean asc) {
            this.asc = asc;
            return this;
        }

        public Builder pageSize(@Nullable Integer i) {
            this.pageSize = i;
            return this;
        }

        public Builder pageIndex(@Nullable Integer i) {
            this.pageIndex = i;
            return this;
        }

        public Builder requiredRole(@Nullable String s) {
            this.requiredRole = s;
            return this;
        }

        public IssueQuery build() {
            this.initPageIndex();
            this.initPageSize();
            if (this.issueKeys != null) {
                Preconditions.checkArgument((this.issueKeys.size() <= 500 ? 1 : 0) != 0, (Object)("Number of issue keys must be less than 500 (got " + this.issueKeys.size() + ")"));
            }
            return new IssueQuery(this);
        }

        private void initPageSize() {
            if (this.components != null && this.components.size() == 1 && this.pageSize == null) {
                this.pageSize = 999999;
            } else if (this.pageSize == null) {
                this.pageSize = 100;
            } else if (this.pageSize <= 0 || this.pageSize > 500) {
                this.pageSize = 500;
            }
        }

        private void initPageIndex() {
            if (this.pageIndex == null) {
                this.pageIndex = 1;
            }
            Preconditions.checkArgument((this.pageIndex > 0 ? 1 : 0) != 0, (Object)("Page index must be greater than 0 (got " + this.pageIndex + ")"));
        }
    }
}

