/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.Encryption;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.DateUtils;

public class Settings
implements BatchComponent,
ServerComponent {
    protected Map<String, String> properties;
    protected PropertyDefinitions definitions;
    private Encryption encryption;

    public Settings() {
        this(new PropertyDefinitions(new Object[0]));
    }

    public Settings(PropertyDefinitions definitions) {
        this.properties = Maps.newHashMap();
        this.definitions = definitions;
        this.encryption = new Encryption(null);
    }

    public Settings(Settings other) {
        this.properties = Maps.newHashMap(other.properties);
        this.definitions = other.definitions;
        this.encryption = other.encryption;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public String getDefaultValue(String key) {
        return this.definitions.getDefaultValue(key);
    }

    public boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean hasDefaultValue(String key) {
        return StringUtils.isNotEmpty((String)this.getDefaultValue(key));
    }

    public String getString(String key) {
        String value = this.getClearString(key);
        if (value != null && this.encryption.isEncrypted(value)) {
            try {
                value = this.encryption.decrypt(value);
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to decrypt the property " + key + ". Please check your secret key.", e);
            }
        }
        return value;
    }

    protected String getClearString(String key) {
        this.doOnGetProperties(key);
        String validKey = this.definitions.validKey(key);
        String value = this.properties.get(validKey);
        if (value == null) {
            value = this.getDefaultValue(validKey);
        }
        return value;
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        return StringUtils.isNotEmpty((String)value) && Boolean.parseBoolean(value);
    }

    public int getInt(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public long getLong(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return Long.parseLong(value);
        }
        return 0L;
    }

    public Date getDate(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return DateUtils.parseDate(value);
        }
        return null;
    }

    public Date getDateTime(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return DateUtils.parseDateTime(value);
        }
        return null;
    }

    public Float getFloat(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("The property '%s' is not a float value", key));
            }
        }
        return null;
    }

    public Double getDouble(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("The property '%s' is not a double value", key));
            }
        }
        return null;
    }

    public String[] getStringArray(String key) {
        PropertyDefinition property = this.getDefinitions().get(key);
        if (null != property && property.multiValues()) {
            String value = this.getString(key);
            if (value == null) {
                return ArrayUtils.EMPTY_STRING_ARRAY;
            }
            ArrayList values = Lists.newArrayList();
            for (String v : Splitter.on((String)",").trimResults().split((CharSequence)value)) {
                values.add(v.replace("%2C", ","));
            }
            return values.toArray(new String[values.size()]);
        }
        return this.getStringArrayBySeparator(key, ",");
    }

    public String[] getStringLines(String key) {
        String value = this.getString(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return value.split("\r?\n|\r", -1);
    }

    public String[] getStringArrayBySeparator(String key, String separator) {
        String value = this.getString(key);
        if (value != null) {
            String[] strings = StringUtils.splitByWholeSeparator((String)value, (String)separator);
            String[] result = new String[strings.length];
            for (int index = 0; index < strings.length; ++index) {
                result[index] = StringUtils.trim((String)strings[index]);
            }
            return result;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public List<String> getKeysStartingWith(String prefix) {
        ArrayList result = Lists.newArrayList();
        for (String key : this.properties.keySet()) {
            if (!StringUtils.startsWith((String)key, (String)prefix)) continue;
            result.add(key);
        }
        return result;
    }

    public Settings appendProperty(String key, String value) {
        String newValue = this.properties.get(this.definitions.validKey(key));
        newValue = StringUtils.isEmpty((String)newValue) ? StringUtils.trim((String)value) : newValue + "," + StringUtils.trim((String)value);
        return this.setProperty(key, newValue);
    }

    public Settings setProperty(String key, @Nullable String[] values) {
        PropertyDefinition property = this.getDefinitions().get(key);
        if (null == property || !property.multiValues()) {
            throw new IllegalStateException("Fail to set multiple values on a single value property " + key);
        }
        String text = null;
        if (values != null) {
            ArrayList escaped = Lists.newArrayList();
            for (String value : values) {
                if (null != value) {
                    escaped.add(value.replace(",", "%2C"));
                    continue;
                }
                escaped.add("");
            }
            String escapedValue = Joiner.on((char)',').join((Iterable)escaped);
            text = StringUtils.trim((String)escapedValue);
        }
        return this.setProperty(key, text);
    }

    public Settings setProperty(String key, @Nullable String value) {
        String validKey = this.definitions.validKey(key);
        if (value == null) {
            this.properties.remove(validKey);
            this.doOnRemoveProperty(validKey);
        } else {
            this.properties.put(validKey, StringUtils.trim((String)value));
            this.doOnSetProperty(validKey, value);
        }
        return this;
    }

    public Settings setProperty(String key, @Nullable Boolean value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Integer value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Long value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Double value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Float value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Date date) {
        return this.setProperty(key, date, false);
    }

    public Settings addProperties(Map<String, String> props) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Settings addProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return this;
    }

    public Settings addSystemProperties() {
        return this.addProperties(System.getProperties());
    }

    public Settings addEnvironmentVariables() {
        return this.addProperties(System.getenv());
    }

    public Settings setProperties(Map<String, String> props) {
        this.clear();
        return this.addProperties(props);
    }

    public Settings setProperty(String key, @Nullable Date date, boolean includeTime) {
        return this.setProperty(key, includeTime ? DateUtils.formatDateTime(date) : DateUtils.formatDate(date));
    }

    public Settings removeProperty(String key) {
        return this.setProperty(key, (String)null);
    }

    public Settings clear() {
        this.properties.clear();
        this.doOnClearProperties();
        return this;
    }

    public Map<String, String> getProperties() {
        return ImmutableMap.copyOf(this.properties);
    }

    public PropertyDefinitions getDefinitions() {
        return this.definitions;
    }

    public static Settings createForComponent(Object component) {
        return new Settings(new PropertyDefinitions(component));
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
    }

    protected void doOnRemoveProperty(String key) {
    }

    protected void doOnClearProperties() {
    }

    protected void doOnGetProperties(String key) {
    }
}

