/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.sonar.api.scan.filesystem.FileType;

public class FileQuery {
    private final Set<FileType> types;
    private final Set<String> languages = Sets.newLinkedHashSet();
    private final Set<String> inclusions = Sets.newLinkedHashSet();
    private final Set<String> exclusions = Sets.newLinkedHashSet();
    private final Collection<FileFilter> filters = Lists.newLinkedList();

    public static FileQuery on(FileType ... types) {
        return new FileQuery(types);
    }

    public static FileQuery onSource() {
        return FileQuery.on(FileType.SOURCE);
    }

    public static FileQuery onTest() {
        return FileQuery.on(FileType.TEST);
    }

    private FileQuery(FileType ... types) {
        this.types = Sets.newHashSet((Object[])types);
    }

    public Collection<FileType> types() {
        return this.types;
    }

    public Collection<String> languages() {
        return this.languages;
    }

    public FileQuery onLanguage(String ... languages) {
        this.languages.addAll(Arrays.asList(languages));
        return this;
    }

    public Collection<String> inclusions() {
        return this.inclusions;
    }

    public FileQuery withInclusions(String ... inclusions) {
        this.inclusions.addAll(Arrays.asList(inclusions));
        return this;
    }

    public Collection<String> exclusions() {
        return this.exclusions;
    }

    public FileQuery withExclusions(String ... exclusions) {
        this.exclusions.addAll(Arrays.asList(exclusions));
        return this;
    }

    public Collection<FileFilter> filters() {
        return this.filters;
    }

    public FileQuery withFilters(FileFilter ... filters) {
        this.filters.addAll(Arrays.asList(filters));
        return this;
    }
}

