/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.qualitymodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.qualitymodel.Characteristic;
import org.sonar.api.rules.Rule;

@Entity
@Table(name="quality_models")
public final class Model
implements Comparable<Model> {
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    @Column(name="name", nullable=false, unique=true, length=100)
    private String name;
    @OneToMany(mappedBy="model", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<Characteristic> characteristics = Lists.newArrayList();

    Model() {
    }

    public static Model create() {
        return new Model();
    }

    public static Model createByName(String s) {
        return new Model().setName(s);
    }

    public Characteristic createCharacteristicByName(String name) {
        Characteristic c = new Characteristic().setName(name, true);
        return this.addCharacteristic(c);
    }

    public Characteristic createCharacteristicByKey(String key, String name) {
        Characteristic c = new Characteristic().setKey(key).setName(name, false);
        return this.addCharacteristic(c);
    }

    public Characteristic createCharacteristicByRule(Rule rule) {
        Characteristic c = new Characteristic().setRule(rule);
        return this.addCharacteristic(c);
    }

    public Integer getId() {
        return this.id;
    }

    Model setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public List<Characteristic> getRootCharacteristics() {
        return this.getCharacteristicsByDepth(1);
    }

    public Model setName(String name) {
        this.name = StringUtils.trim((String)name);
        return this;
    }

    public Characteristic addCharacteristic(Characteristic c) {
        c.setModel(this);
        c.setOrder(this.characteristics.size() + 1);
        this.characteristics.add(c);
        return c;
    }

    public List<Characteristic> getCharacteristics() {
        return this.getCharacteristics(true);
    }

    public List<Characteristic> getCharacteristics(boolean onlyEnabled) {
        if (!onlyEnabled) {
            return this.characteristics;
        }
        ArrayList result = Lists.newArrayList();
        for (Characteristic characteristic : this.characteristics) {
            if (!characteristic.getEnabled().booleanValue()) continue;
            result.add(characteristic);
        }
        return result;
    }

    public Characteristic getCharacteristicByKey(String key) {
        for (Characteristic characteristic : this.characteristics) {
            if (!characteristic.getEnabled().booleanValue() || !StringUtils.equals((String)key, (String)characteristic.getKey())) continue;
            return characteristic;
        }
        return null;
    }

    public Characteristic getCharacteristicByRule(Rule rule) {
        if (rule != null) {
            for (Characteristic characteristic : this.characteristics) {
                if (!characteristic.getEnabled().booleanValue() || !ObjectUtils.equals((Object)rule, (Object)characteristic.getRule())) continue;
                return characteristic;
            }
        }
        return null;
    }

    public List<Characteristic> getCharacteristicsByDepth(int depth) {
        ArrayList result = Lists.newArrayList();
        for (Characteristic c : this.characteristics) {
            if (!c.getEnabled().booleanValue() || c.getDepth() != depth) continue;
            result.add(c);
        }
        return result;
    }

    public Characteristic getCharacteristicByName(String name) {
        for (Characteristic characteristic : this.characteristics) {
            if (!characteristic.getEnabled().booleanValue() || !StringUtils.equals((String)name, (String)characteristic.getName())) continue;
            return characteristic;
        }
        return null;
    }

    public Model removeCharacteristic(Characteristic characteristic) {
        if (characteristic.getId() == null) {
            this.characteristics.remove(characteristic);
            for (Characteristic parent : characteristic.getParents()) {
                parent.removeChild(characteristic);
            }
        } else {
            characteristic.setEnabled(false);
        }
        for (Characteristic child : characteristic.getChildren()) {
            this.removeCharacteristic(child);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model model = (Model)o;
        return !(this.name != null ? !this.name.equals(model.name) : model.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).toString();
    }

    @Override
    public int compareTo(Model o) {
        return this.getName().compareTo(o.getName());
    }
}

