/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.base.Objects;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.Settings;

public class EmailSettings
implements BatchComponent,
ServerComponent {
    public static final String SMTP_HOST = "email.smtp_host.secured";
    public static final String SMTP_HOST_DEFAULT = "";
    public static final String SMTP_PORT = "email.smtp_port.secured";
    public static final String SMTP_PORT_DEFAULT = "25";
    public static final String SMTP_SECURE_CONNECTION = "email.smtp_secure_connection.secured";
    public static final String SMTP_SECURE_CONNECTION_DEFAULT = "";
    public static final String SMTP_USERNAME = "email.smtp_username.secured";
    public static final String SMTP_USERNAME_DEFAULT = "";
    public static final String SMTP_PASSWORD = "email.smtp_password.secured";
    public static final String SMTP_PASSWORD_DEFAULT = "";
    public static final String FROM = "email.from";
    public static final String FROM_DEFAULT = "noreply@nowhere";
    public static final String PREFIX = "email.prefix";
    public static final String PREFIX_DEFAULT = "[SONAR]";
    private final Settings settings;

    public EmailSettings(Settings settings) {
        this.settings = settings;
    }

    public String getSmtpHost() {
        return this.get(SMTP_HOST, "");
    }

    public int getSmtpPort() {
        return Integer.parseInt(this.get(SMTP_PORT, SMTP_PORT_DEFAULT));
    }

    public String getSecureConnection() {
        return this.get(SMTP_SECURE_CONNECTION, "");
    }

    public String getSmtpUsername() {
        return this.get(SMTP_USERNAME, "");
    }

    public String getSmtpPassword() {
        return this.get(SMTP_PASSWORD, "");
    }

    public String getFrom() {
        return this.get(FROM, FROM_DEFAULT);
    }

    public String getPrefix() {
        return this.get(PREFIX, PREFIX_DEFAULT);
    }

    public String getServerBaseURL() {
        return this.get("sonar.core.serverBaseURL", "http://localhost:9000");
    }

    private String get(String key, String defaultValue) {
        return (String)Objects.firstNonNull((Object)this.settings.getString(key), (Object)defaultValue);
    }
}

