/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.token;

public class Token {
    private final int line;
    private final int column;
    private final String value;
    private int hash;

    public Token(String value, int line, int column) {
        this.value = value;
        this.column = column;
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Token) {
            Token anotherToken = (Token)object;
            return anotherToken.line == this.line && anotherToken.column == this.column && anotherToken.value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.value.hashCode();
            h = 31 * h + this.line;
            this.hash = h = 31 * h + this.column;
        }
        return h;
    }

    public String toString() {
        return "'" + this.value + "'[" + this.line + "," + this.column + "]";
    }
}

