/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import com.google.common.annotations.Beta;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenEntry
implements Comparable<TokenEntry> {
    private static final Map<String, Integer> TOKENS = new HashMap<String, Integer>();
    private static int tokenCount = 0;
    public static final TokenEntry EOF = new TokenEntry();
    private String tokenSrcID;
    private int beginLine;
    private int index;
    private int identifier;
    private int hashCode;
    private final String value;

    private TokenEntry() {
        this.identifier = 0;
        this.tokenSrcID = "EOFMarker";
        this.value = "";
    }

    public TokenEntry(String image, String tokenSrcID, int beginLine) {
        Integer i = TOKENS.get(image);
        if (i == null) {
            i = TOKENS.size() + 1;
            TOKENS.put(image, i);
        }
        this.identifier = i;
        this.tokenSrcID = tokenSrcID;
        this.beginLine = beginLine;
        this.index = tokenCount++;
        this.value = image;
    }

    @Beta
    public String getValue() {
        return this.value;
    }

    public static TokenEntry getEOF() {
        ++tokenCount;
        return EOF;
    }

    public static void clearImages() {
        TOKENS.clear();
        tokenCount = 0;
    }

    public String getTokenSrcID() {
        return this.tokenSrcID;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TokenEntry)) {
            return false;
        }
        TokenEntry other = (TokenEntry)o;
        return other.hashCode == this.hashCode;
    }

    @Override
    public int compareTo(TokenEntry other) {
        return this.getIndex() - other.getIndex();
    }
}

