/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.detector.ContainsInComparator;
import org.sonar.duplications.detector.suffixtree.Search;
import org.sonar.duplications.detector.suffixtree.TextSet;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.ClonePart;
import org.sonar.duplications.utils.SortedListsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicationsCollector
extends Search.Collector {
    private final TextSet text;
    private final String originResourceId;
    private final List<CloneGroup> filtered = Lists.newArrayList();
    private int length;
    private ClonePart origin;
    private List<ClonePart> parts;

    public DuplicationsCollector(TextSet text) {
        this.text = text;
        this.originResourceId = text.getBlock(0).getResourceId();
    }

    public List<CloneGroup> getResult() {
        return this.filtered;
    }

    @Override
    public void startOfGroup(int size, int length) {
        this.length = length;
        this.parts = Lists.newArrayListWithCapacity((int)size);
    }

    @Override
    public void part(int start, int end) {
        Block firstBlock = this.text.getBlock(start);
        Block lastBlock = this.text.getBlock(end - 1);
        ClonePart part = new ClonePart(firstBlock.getResourceId(), firstBlock.getIndexInFile(), firstBlock.getFirstLineNumber(), lastBlock.getLastLineNumber());
        if (this.originResourceId.equals(part.getResourceId())) {
            if (this.origin == null) {
                this.origin = part;
            } else if (part.getUnitStart() < this.origin.getUnitStart()) {
                this.origin = part;
            }
        }
        this.parts.add(part);
    }

    @Override
    public void endOfGroup() {
        Collections.sort(this.parts, ContainsInComparator.CLONEPART_COMPARATOR);
        CloneGroup group = new CloneGroup(this.length, this.origin, this.parts);
        this.filter(group);
        this.parts = null;
        this.origin = null;
    }

    private void filter(CloneGroup current) {
        for (CloneGroup earlier : this.filtered) {
            if (!DuplicationsCollector.containsIn(current, earlier)) continue;
            return;
        }
        this.filtered.add(current);
    }

    private static boolean containsIn(CloneGroup first, CloneGroup second) {
        List<ClonePart> firstParts = first.getCloneParts();
        List<ClonePart> secondParts = second.getCloneParts();
        return SortedListsUtils.contains(secondParts, firstParts, new ContainsInComparator(second.getCloneUnitLength(), first.getCloneUnitLength())) && SortedListsUtils.contains(firstParts, secondParts, ContainsInComparator.RESOURCE_ID_COMPARATOR);
    }
}

