/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;

class TempCleaning {
    static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    final File tempDir;

    TempCleaning() {
        this(new File(System.getProperty("java.io.tmpdir")));
    }

    TempCleaning(File tempDir) {
        this.tempDir = tempDir;
    }

    void clean() {
        long cutoff = System.currentTimeMillis() - 86400000L;
        Collection<File> files = FileUtils.listFiles(this.tempDir, new AndFileFilter(new PrefixFileFilter("sonar-runner-batch"), new AgeFileFilter(cutoff)), null);
        for (File file : files) {
            FileUtils.deleteQuietly(file);
        }
    }
}

