/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class JarUnsignMojo
extends AbstractMojo {
    private boolean skip;
    private File tempDirectory;
    private File jarPath;
    private boolean verbose;
    private MavenProjectHelper projectHelper;
    protected ArchiverManager archiverManager;
    private final String[] EXT_ARRAY = new String[]{"DSA", "RSA", "SF"};
    private FileFilter removeSignatureFileFilter = new FileFilter(){
        private final List EXT_TO_REMOVE;
        {
            this.EXT_TO_REMOVE = Arrays.asList(JarUnsignMojo.this.EXT_ARRAY);
        }

        public boolean accept(File file) {
            String extension = FileUtils.getExtension((String)file.getAbsolutePath());
            return this.EXT_TO_REMOVE.contains(extension);
        }
    };

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)("Skipping JAR unsigning for file: " + this.jarPath.getAbsolutePath()));
            return;
        }
        File jarFile = this.jarPath;
        File tempDirParent = this.tempDirectory;
        String archiveExt = FileUtils.getExtension((String)jarFile.getAbsolutePath()).toLowerCase();
        File tempDir = new File(tempDirParent, jarFile.getName());
        if (!tempDir.mkdirs()) {
            throw new MojoExecutionException("Error creating temporary directory: " + tempDir);
        }
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(jarFile);
            unArchiver.setDestDirectory(tempDir);
            unArchiver.extract();
        }
        catch (ArchiverException ex) {
            throw new MojoExecutionException("Error unpacking file: " + jarFile + "to: " + tempDir, (Exception)((Object)ex));
        }
        catch (NoSuchArchiverException ex) {
            throw new MojoExecutionException("Error acquiring unarchiver for extension: " + archiveExt, (Exception)((Object)ex));
        }
        File metaInf = new File(tempDir, "META-INF");
        if (!metaInf.isDirectory()) {
            this.verboseLog("META-INT dir not found : nothing to do for file: " + this.jarPath.getAbsolutePath());
            return;
        }
        File[] filesToRemove = metaInf.listFiles(this.removeSignatureFileFilter);
        if (filesToRemove.length == 0) {
            this.verboseLog("no files match " + this.toString(this.EXT_ARRAY) + " : nothing to do for file: " + this.jarPath.getAbsolutePath());
            return;
        }
        for (int i = 0; i < filesToRemove.length; ++i) {
            if (!filesToRemove[i].delete()) {
                throw new MojoExecutionException("Error removing signature file: " + filesToRemove[i]);
            }
            this.verboseLog("remove file :" + filesToRemove[i]);
        }
        try {
            JarArchiver jarArchiver = (JarArchiver)this.archiverManager.getArchiver("jar");
            jarArchiver.setUpdateMode(false);
            jarArchiver.addDirectory(tempDir);
            jarArchiver.setDestFile(jarFile);
            jarArchiver.createArchive();
        }
        catch (ArchiverException ex) {
            throw new MojoExecutionException("Error packing directory: " + tempDir + "to: " + jarFile, (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error packing directory: " + tempDir + "to: " + jarFile, (Exception)ex);
        }
        catch (NoSuchArchiverException ex) {
            throw new MojoExecutionException("Error acquiring archiver for extension: jar", (Exception)((Object)ex));
        }
        try {
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error cleaning up temporary directory file: " + tempDir, (Exception)ex);
        }
    }

    protected void verboseLog(String msg) {
        this.infoOrDebug(this.isVerbose() || this.getLog().isInfoEnabled(), msg);
    }

    private void infoOrDebug(boolean info, String msg) {
        if (info) {
            this.getLog().info((CharSequence)msg);
        } else {
            this.getLog().debug((CharSequence)msg);
        }
    }

    public void setTempDir(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public void setJarPath(File jarPath) {
        this.jarPath = jarPath;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setArchiverManager(ArchiverManager archiverManager) {
        this.archiverManager = archiverManager;
    }

    public String toString(String[] items) {
        StringBuffer back = new StringBuffer("{");
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                back.append(", ");
            }
            back.append('\"').append(items[i]).append('\"');
        }
        back.append("}");
        return back.toString();
    }
}

