/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.versions.reporting.DependencyUpdatesReportRenderer;
import org.codehaus.mojo.versions.reporting.ParentUpdatesReportRenderer;
import org.codehaus.mojo.versions.reporting.PluginUpdatesReportRenderer;
import org.codehaus.mojo.versions.reporting.PropertyUpdatesReportRenderer;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.ParentUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesModel;
import org.codehaus.mojo.versions.reporting.util.ReportRenderer;
import org.codehaus.plexus.i18n.I18N;

@Named
@Singleton
public class ReportRendererFactoryImpl
implements ReportRendererFactory {
    public static final String DEPENDENCY_UPDATES_REPORT = "dependency-updates-report";
    public static final String DEPENDENCY_UPDATES_AGGREGATE_REPORT = "dependency-updates-aggregate-report";
    public static final String PLUGIN_UPDATES_REPORT = "plugin-updates-report";
    public static final String PLUGIN_UPDATES_AGGREGATE_REPORT = "plugin-updates-aggregate-report";
    public static final String PROPERTY_UPDATES_REPORT = "property-updates-report";
    public static final String PROPERTY_UPDATES_AGGREGATE_REPORT = "property-updates-aggregate-report";
    public static final String PARENT_UPDATES_REPORT = "parent-updates-report";
    private final I18N i18N;

    @Inject
    public ReportRendererFactoryImpl(I18N i18N) {
        this.i18N = i18N;
    }

    @Override
    public <T extends ReportRenderer, U> T createReportRenderer(String reportName, Sink sink, Locale locale, U model, boolean allowSnapshots) throws IllegalArgumentException {
        switch (reportName) {
            case "dependency-updates-report": 
            case "dependency-updates-aggregate-report": {
                return (T)new DependencyUpdatesReportRenderer<DependencyUpdatesModel>(this.i18N, sink, locale, reportName, (DependencyUpdatesModel)model, allowSnapshots);
            }
            case "plugin-updates-report": 
            case "plugin-updates-aggregate-report": {
                return (T)new PluginUpdatesReportRenderer(this.i18N, sink, locale, reportName, (PluginUpdatesModel)model, allowSnapshots);
            }
            case "property-updates-report": 
            case "property-updates-aggregate-report": {
                return (T)new PropertyUpdatesReportRenderer(this.i18N, sink, locale, reportName, (PropertyUpdatesModel)model, allowSnapshots);
            }
            case "parent-updates-report": {
                return (T)new ParentUpdatesReportRenderer(this.i18N, sink, locale, reportName, (ParentUpdatesModel)model, allowSnapshots);
            }
        }
        throw new IllegalArgumentException("Invalid report name: " + reportName);
    }
}

